/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.util;

import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.routing.SQLExecutionUnit;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"Sharding-JDBC-SQL");

    public static void logSQL(String logicSQL, SQLStatement sqlStatement, Collection<SQLExecutionUnit> sqlExecutionUnits, List<Object> parameters) {
        SQLLogger.log("Logic SQL: {}", logicSQL);
        SQLLogger.log("SQLStatement: {}", sqlStatement);
        for (SQLExecutionUnit each : sqlExecutionUnits) {
            if (parameters.isEmpty()) {
                SQLLogger.log("Actual SQL: {} ::: {}", each.getDataSource(), each.getSql());
                continue;
            }
            SQLLogger.log("Actual SQL: {} ::: {} ::: {}", each.getDataSource(), each.getSql(), parameters);
        }
    }

    private static void log(String pattern, Object ... arguments) {
        log.info(pattern, arguments);
    }

    private SQLLogger() {
    }
}

