/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.model;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IstioService {
    private String name;
    private String groupName;
    private String namespace;
    private Long revision;
    private List<Instance> hosts;
    private Date createTimeStamp;

    public IstioService(Service service, ServiceInfo serviceInfo) {
        this.name = serviceInfo.getName();
        this.groupName = serviceInfo.getGroupName();
        this.namespace = service.getNamespace();
        this.revision = service.getRevision();
        this.createTimeStamp = new Date();
        this.hosts = this.sanitizeServiceInfo(serviceInfo);
    }

    public IstioService(Service service, ServiceInfo serviceInfo, IstioService old) {
        this.name = serviceInfo.getName();
        this.groupName = serviceInfo.getGroupName();
        this.namespace = service.getNamespace();
        this.revision = service.getRevision();
        this.createTimeStamp = old.getCreateTimeStamp();
        this.hosts = this.sanitizeServiceInfo(serviceInfo);
    }

    private List<Instance> sanitizeServiceInfo(ServiceInfo serviceInfo) {
        List<Object> hosts = new ArrayList<Instance>();
        for (Instance instance : serviceInfo.getHosts()) {
            if (!instance.isHealthy() || !instance.isEnabled()) continue;
            hosts.add(instance);
        }
        if (hosts.isEmpty()) {
            hosts = serviceInfo.getHosts();
        }
        return hosts;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Long getRevision() {
        return this.revision;
    }

    public List<Instance> getHosts() {
        return this.hosts;
    }

    public Date getCreateTimeStamp() {
        return this.createTimeStamp;
    }
}

