/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Iterables;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.AbstractModelConverter;
import io.swagger.jackson.JAXBAnnotationsHelper;
import io.swagger.jackson.TypeNameResolver;
import io.swagger.oas.annotations.media.DiscriminatorMapping;
import io.swagger.oas.annotations.media.Schema;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.BinarySchema;
import io.swagger.oas.models.media.ByteArraySchema;
import io.swagger.oas.models.media.ComposedSchema;
import io.swagger.oas.models.media.DateSchema;
import io.swagger.oas.models.media.DateTimeSchema;
import io.swagger.oas.models.media.Discriminator;
import io.swagger.oas.models.media.EmailSchema;
import io.swagger.oas.models.media.IntegerSchema;
import io.swagger.oas.models.media.MapSchema;
import io.swagger.oas.models.media.NumberSchema;
import io.swagger.oas.models.media.PasswordSchema;
import io.swagger.oas.models.media.StringSchema;
import io.swagger.oas.models.media.UUIDSchema;
import io.swagger.oas.models.media.XML;
import io.swagger.util.PrimitiveType;
import io.swagger.util.RefUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)type;
            this.LOGGER.debug("Can't check class {}, {}", (Object)type, (Object)rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public io.swagger.oas.models.media.Schema resolve(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    private Schema getSchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Schema)) continue;
            return (Schema)annotation;
        }
        return null;
    }

    public io.swagger.oas.models.media.Schema resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        this.LOGGER.debug("resolveProperty {}", (Object)propType);
        io.swagger.oas.models.media.Schema property = null;
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                property = new MapSchema().additionalProperties(context.resolve((Type)valueType, new Annotation[0]));
            } else if (valueType != null) {
                io.swagger.oas.models.media.Schema items = context.resolve((Type)valueType, new Annotation[0]);
                if (annotations != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        XML xml = items.getXml() != null ? items.getXml() : new XML();
                        xml.setName(xmlElement.name());
                        items.setXml(xml);
                    }
                }
                ArraySchema arrayProperty = new ArraySchema().items(items);
                if (this._isSetType(propType.getRawClass())) {
                    arrayProperty.setUniqueItems(Boolean.valueOf(true));
                }
                property = arrayProperty;
            }
        } else {
            Schema schemaAnnotation = this.getSchemaAnnotation(annotations);
            if (schemaAnnotation != null && !StringUtils.isBlank((CharSequence)schemaAnnotation.format()) && propType.getRawClass().isAssignableFrom(String.class)) {
                if ("password".equals(schemaAnnotation.format())) {
                    property = new PasswordSchema();
                } else if ("binary".equals(schemaAnnotation.format())) {
                    property = new BinarySchema();
                } else if ("byte".equals(schemaAnnotation.format())) {
                    property = new ByteArraySchema();
                } else if ("date".equals(schemaAnnotation.format())) {
                    property = new DateSchema();
                } else if ("date-time".equals(schemaAnnotation.format())) {
                    property = new DateTimeSchema();
                } else if ("email".equals(schemaAnnotation.format())) {
                    property = new EmailSchema();
                } else if ("uuid".equals(schemaAnnotation.format())) {
                    property = new UUIDSchema();
                } else {
                    property = new StringSchema();
                    property.format(schemaAnnotation.format());
                }
            } else {
                property = PrimitiveType.createProperty((Type)propType);
            }
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new StringSchema();
                this._addEnumProps(propType.getRawClass(), property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolve((Type)propType.containedType(0), null);
            } else {
                io.swagger.oas.models.media.Schema innerModel = context.resolve((Type)propType);
                if (innerModel instanceof io.swagger.oas.models.media.Schema) {
                    io.swagger.oas.models.media.Schema mi = innerModel;
                    if ("object".equals(mi.getType())) {
                        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(propType);
                        String name = this._typeName(propType, beanDesc);
                        property = new io.swagger.oas.models.media.Schema().$ref(RefUtils.constructRef(name));
                    } else {
                        property = mi.get$ref() != null ? new io.swagger.oas.models.media.Schema().$ref(StringUtils.isNotEmpty((CharSequence)mi.get$ref()) ? mi.get$ref() : mi.getTitle()) : innerModel;
                    }
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    @Override
    public io.swagger.oas.models.media.Schema resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, io.swagger.oas.models.media.Schema property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringSchema)) continue;
            StringSchema sp = (StringSchema)property;
            sp.addEnumItem(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public io.swagger.oas.models.media.Schema resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        JsonTypeInfo typeInfo;
        Schema schemaAnnotation;
        String disc;
        String title;
        if (type.isEnumType()) {
            return null;
        }
        if (PrimitiveType.fromType((Type)type) != null) {
            return PrimitiveType.fromType((Type)type).createProperty();
        }
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = this._typeName(type, beanDesc);
        if ("Object".equals(name)) {
            return new io.swagger.oas.models.media.Schema();
        }
        io.swagger.oas.models.media.Schema resolvedModel = context.resolve(type.getRawClass());
        if (resolvedModel != null) {
            return resolvedModel;
        }
        List<Class<?>> composedSchemaReferencedClasses = this.getComposedSchemaReferencedClasses(type.getRawClass());
        boolean isComposedSchema = composedSchemaReferencedClasses != null;
        io.swagger.oas.models.media.Schema model = isComposedSchema ? new ComposedSchema().type("object").name(name).description(this._description((Annotated)beanDesc.getClassInfo())) : new io.swagger.oas.models.media.Schema().type("object").name(name).description(this._description((Annotated)beanDesc.getClassInfo()));
        Schema schemaAnnotationForTitle = type.getRawClass().getAnnotation(Schema.class);
        String string = title = schemaAnnotationForTitle == null ? null : StringUtils.trimToNull((String)schemaAnnotationForTitle.title());
        if (!StringUtils.isBlank((CharSequence)title)) {
            model.title(title);
        }
        if (!type.isContainerType()) {
            context.defineModel(name, model, (Type)type, null);
        }
        if (type.isContainerType()) {
            context.resolve((Type)type.getContentType());
            return null;
        }
        XmlRootElement rootAnnotation = (XmlRootElement)beanDesc.getClassAnnotations().get(XmlRootElement.class);
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            this.LOGGER.debug("{}", (Object)rootAnnotation);
            XML xml = new XML().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            model.xml(xml);
        }
        XmlAccessorType xmlAccessorTypeAnnotation = (XmlAccessorType)beanDesc.getClassAnnotations().get(XmlAccessorType.class);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        ArrayList<io.swagger.oas.models.media.Schema> props = new ArrayList<io.swagger.oas.models.media.Schema>();
        LinkedHashMap<String, io.swagger.oas.models.media.Schema> modelProps = new LinkedHashMap<String, io.swagger.oas.models.media.Schema>();
        for (BeanPropertyDefinition propDef : beanDesc.findProperties()) {
            JsonProperty jsonProperty;
            String altName;
            Member member;
            io.swagger.oas.models.media.Schema property = null;
            String propName = propDef.getName();
            Annotation[] annotations = null;
            if (propDef.getPrimaryMember() != null && (member = propDef.getPrimaryMember().getMember()) != null && (altName = member.getName()) != null) {
                int length = altName.length();
                for (String prefix : Arrays.asList("get", "is")) {
                    int offset = prefix.length();
                    if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                    propName = altName;
                    break;
                }
            }
            PropertyMetadata propertyMetadata = propDef.getMetadata();
            int hasSetter = 0;
            int hasGetter = 0;
            try {
                hasSetter = propDef.getSetter() == null ? 0 : 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hasSetter = 1;
            }
            if (propDef.getGetter() != null && (jsonProperty = (JsonProperty)propDef.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = 1;
            }
            Object var26_43 = null;
            if (hasSetter == 0 & hasGetter) {
                Boolean bl = Boolean.TRUE;
            } else {
                Boolean bl = Boolean.FALSE;
            }
            AnnotatedMember member2 = propDef.getPrimaryMember();
            Boolean allowEmptyValue = null;
            String minimum = null;
            String maximum = null;
            boolean exclusiveMinimum = false;
            boolean exclusiveMaximum = false;
            if (member2 == null || this.ignore((Annotated)member2, xmlAccessorTypeAnnotation, propName, propertiesToIgnore)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member2.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            Schema mp = null;
            io.swagger.oas.annotations.media.ArraySchema as = null;
            as = (io.swagger.oas.annotations.media.ArraySchema)member2.getAnnotation(io.swagger.oas.annotations.media.ArraySchema.class);
            mp = as != null ? as.schema() : (Schema)member2.getAnnotation(Schema.class);
            if (mp != null) {
                if (mp.readOnly()) {
                    Boolean bl = mp.readOnly();
                }
                allowEmptyValue = mp.nullable() ? Boolean.valueOf(mp.nullable()) : null;
                if (StringUtils.isNotBlank((CharSequence)mp.minimum()) && !String.valueOf(Integer.MAX_VALUE).equals(mp.minimum())) {
                    minimum = mp.minimum();
                }
                if (StringUtils.isNotBlank((CharSequence)mp.maximum()) && !String.valueOf(Integer.MIN_VALUE).equals(mp.maximum())) {
                    maximum = mp.maximum();
                }
                if (mp.exclusiveMinimum()) {
                    exclusiveMinimum = true;
                }
                if (mp.exclusiveMaximum()) {
                    exclusiveMaximum = true;
                }
            }
            JavaType propType = member2.getType(beanDesc.bindingsForBeanType());
            if (mp != null && !mp.name().isEmpty()) {
                propName = mp.name();
            }
            if (mp != null && !Void.class.equals((Object)mp.implementation())) {
                Class cls = mp.implementation();
                this.LOGGER.debug("overriding datatype from {} to {}", (Object)propType, (Object)cls.getName());
                if (as != null) {
                    ArraySchema propertySchema = new ArraySchema();
                    io.swagger.oas.models.media.Schema innerSchema = null;
                    io.swagger.oas.models.media.Schema primitiveProperty = PrimitiveType.createProperty(cls);
                    innerSchema = primitiveProperty != null ? primitiveProperty : context.resolve(cls, annotations);
                    propertySchema.setItems(innerSchema);
                    property = propertySchema;
                } else {
                    property = context.resolve(cls, annotations);
                }
            }
            if (property == null) {
                if (mp != null && StringUtils.isNotEmpty((CharSequence)mp.ref())) {
                    property = new io.swagger.oas.models.media.Schema().$ref(mp.ref());
                }
                if (property == null) {
                    JsonUnwrapped uw = (JsonUnwrapped)member2.getAnnotation(JsonUnwrapped.class);
                    if (uw != null && uw.enabled()) {
                        this.handleUnwrapped(props, context.resolve((Type)propType), uw.prefix(), uw.suffix());
                    } else {
                        property = context.resolve((Type)propType, annotations);
                    }
                }
            }
            if (property != null) {
                property.setName(propName);
                if (property.get$ref() == null) {
                    void var26_36;
                    String description;
                    Boolean required = propertyMetadata.getRequired();
                    if (required != null && !Boolean.FALSE.equals(required)) {
                        model.addRequiredItem(propName);
                    }
                    if ((description = this._intr.findPropertyDescription((Annotated)member2)) != null && !"".equals(description)) {
                        property.setDescription(description);
                    }
                    Integer index = this._intr.findPropertyIndex((Annotated)member2);
                    String _defaultValue = this._findDefaultValue((Annotated)member2);
                    property.setDefault((Object)_defaultValue);
                    if (minimum != null) {
                        property.minimum(new BigDecimal(minimum));
                    }
                    if (maximum != null) {
                        property.maximum(new BigDecimal(maximum));
                    }
                    if (exclusiveMaximum) {
                        property.exclusiveMaximum(Boolean.valueOf(true));
                    }
                    if (exclusiveMinimum) {
                        property.exclusiveMinimum(Boolean.valueOf(true));
                    }
                    property.setExample((Object)this._findExampleValue((Annotated)member2));
                    property.setReadOnly(this._findReadOnly((Annotated)member2));
                    if (allowEmptyValue != null) {
                        property.setNullable(allowEmptyValue);
                    }
                    if (property.getReadOnly() == null && var26_36.booleanValue()) {
                        property.setReadOnly((Boolean)var26_36);
                    }
                    if (mp != null) {
                        if (!StringUtils.isBlank((CharSequence)mp.pattern())) {
                            property.setPattern(mp.pattern());
                        }
                        if (mp.allowableValues().length > 0) {
                            for (String _enum : mp.allowableValues()) {
                                if (!StringUtils.isNotBlank((CharSequence)_enum)) continue;
                                property.addEnumItemObject((Object)_enum);
                            }
                        }
                    }
                    JAXBAnnotationsHelper.apply(member2, property);
                    this.applyBeanValidatorAnnotations(property, annotations, model);
                }
            }
            if (property == null) continue;
            props.add(property);
            modelProps.put(propName, property);
        }
        if (modelProps.size() > 0) {
            model.setProperties(modelProps);
        }
        Class currentType = type.getRawClass();
        context.defineModel(name, model, currentType, null);
        if (!this.resolveSubtypes(model, beanDesc, context)) {
            model.setDiscriminator(null);
        }
        String string2 = disc = (schemaAnnotation = type.getRawClass().getAnnotation(Schema.class)) == null ? "" : schemaAnnotation.discriminatorProperty();
        if (disc.isEmpty() && (typeInfo = type.getRawClass().getAnnotation(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            DiscriminatorMapping[] mappings;
            Discriminator discriminator = new Discriminator().propertyName(disc);
            if (schemaAnnotation != null && (mappings = schemaAnnotation.discriminatorMapping()) != null && mappings.length > 0) {
                for (DiscriminatorMapping discriminatorMapping : mappings) {
                    if (discriminatorMapping.value().isEmpty() || discriminatorMapping.schema().equals(Void.class)) continue;
                    discriminator.mapping(discriminatorMapping.value(), RefUtils.constructRef(context.resolve(discriminatorMapping.schema()).getName()));
                }
            }
            model.setDiscriminator(discriminator);
        }
        if (schemaAnnotation != null) {
            Class not;
            String ref = schemaAnnotation.ref();
            if (!StringUtils.isBlank((CharSequence)ref)) {
                model.$ref(ref);
            }
            if (!Void.class.equals((Object)(not = schemaAnnotation.not()))) {
                model.not(new io.swagger.oas.models.media.Schema().$ref(context.resolve(not).getName()));
            }
            if (schemaAnnotation.requiredProperties() != null && schemaAnnotation.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)schemaAnnotation.requiredProperties()[0])) {
                for (String string3 : schemaAnnotation.requiredProperties()) {
                    model.addRequiredItem(string3);
                }
            }
        }
        if (isComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            Class[] allOf = schemaAnnotation.allOf();
            Class[] classArray = schemaAnnotation.anyOf();
            Class[] oneOf = schemaAnnotation.oneOf();
            List<Class> allOfFiltered = Stream.of(allOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            allOfFiltered.forEach(c -> {
                io.swagger.oas.models.media.Schema allOfRef = context.resolve((Type)c);
                io.swagger.oas.models.media.Schema refSchema = new io.swagger.oas.models.media.Schema().$ref(allOfRef.getName());
                if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                    composedSchema.addAllOfItem(refSchema);
                }
                this.removeParentProperties((io.swagger.oas.models.media.Schema)composedSchema, allOfRef);
            });
            List<Class> list = Stream.of(classArray).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            list.forEach(c -> {
                io.swagger.oas.models.media.Schema anyOfRef = context.resolve((Type)c);
                composedSchema.addAnyOfItem(new io.swagger.oas.models.media.Schema().$ref(anyOfRef.getName()));
                this.removeParentProperties((io.swagger.oas.models.media.Schema)composedSchema, anyOfRef);
            });
            List<Class> oneOfFiltered = Stream.of(oneOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            oneOfFiltered.forEach(c -> {
                io.swagger.oas.models.media.Schema oneOfRef = context.resolve((Type)c);
                composedSchema.addOneOfItem(new io.swagger.oas.models.media.Schema().$ref(oneOfRef.getName()));
                this.removeParentProperties((io.swagger.oas.models.media.Schema)composedSchema, oneOfRef);
            });
        }
        return model;
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class);
    }

    private void handleUnwrapped(List<io.swagger.oas.models.media.Schema> props, io.swagger.oas.models.media.Schema innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix) && StringUtils.isBlank((CharSequence)prefix)) {
            props.addAll(innerModel.getProperties().values());
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            for (io.swagger.oas.models.media.Schema schema : innerModel.getProperties().values()) {
            }
        }
    }

    protected void applyBeanValidatorAnnotations(io.swagger.oas.models.media.Schema property, Annotation[] annotations, io.swagger.oas.models.media.Schema parent) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (annos.containsKey("javax.validation.constraints.NotNull")) {
            parent.addRequiredItem(property.getName());
        }
        if (annos.containsKey("javax.validation.constraints.Min") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            property.setMinimum(new BigDecimal(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            property.setMaximum(new BigDecimal(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if ("integer".equals(property.getType()) || "number".equals(property.getType())) {
                property.setMinimum(new BigDecimal(size.min()));
                property.setMaximum(new BigDecimal(size.max()));
            } else if (property instanceof StringSchema) {
                StringSchema sp = (StringSchema)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            } else if (property instanceof ArraySchema) {
                ArraySchema sp = (ArraySchema)property;
                sp.setMinItems(Integer.valueOf(size.min()));
                sp.setMaxItems(Integer.valueOf(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMinimum(new BigDecimal(min.value()));
                ap.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMaximum(new BigDecimal(max.value()));
                ap.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.Pattern")) {
            Pattern pattern = (Pattern)annos.get("javax.validation.constraints.Pattern");
            if (property instanceof StringSchema) {
                property.setPattern(pattern.regexp());
            }
        }
    }

    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = ReflectionUtils.loadClassByName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveSubtypes(io.swagger.oas.models.media.Schema model, BeanDescription bean, ModelConverterContext context) {
        List types = this._intr.findSubtypes((Annotated)bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        boolean count = false;
        Class beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Class subtypeType = subtype.getType();
            if (!beanClass.isAssignableFrom(subtypeType)) continue;
            io.swagger.oas.models.media.Schema subtypeModel = context.resolve(subtypeType);
            if (subtypeModel.getName().equals(model.getName())) {
                subtypeModel.setName(this._typeNameResolver.nameForType(this._mapper.constructType((Type)subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            ComposedSchema composedSchema = null;
            composedSchema = !(subtypeModel instanceof ComposedSchema) ? (ComposedSchema)new ComposedSchema().title(subtypeModel.getTitle()).name(subtypeModel.getName()).deprecated(subtypeModel.getDeprecated()).additionalProperties(subtypeModel.getAdditionalProperties()).description(subtypeModel.getDescription()).discriminator(subtypeModel.getDiscriminator()).example(subtypeModel.getExample()).exclusiveMaximum(subtypeModel.getExclusiveMaximum()).exclusiveMinimum(subtypeModel.getExclusiveMinimum()).externalDocs(subtypeModel.getExternalDocs()).format(subtypeModel.getFormat()).maximum(subtypeModel.getMaximum()).maxItems(subtypeModel.getMaxItems()).maxLength(subtypeModel.getMaxLength()).maxProperties(subtypeModel.getMaxProperties()).minimum(subtypeModel.getMinimum()).minItems(subtypeModel.getMinItems()).minLength(subtypeModel.getMinLength()).minProperties(subtypeModel.getMinProperties()).multipleOf(subtypeModel.getMultipleOf()).not(subtypeModel.getNot()).nullable(subtypeModel.getNullable()).pattern(subtypeModel.getPattern()).properties(subtypeModel.getProperties()).readOnly(subtypeModel.getReadOnly()).required(subtypeModel.getRequired()).type(subtypeModel.getType()).uniqueItems(subtypeModel.getUniqueItems()).writeOnly(subtypeModel.getWriteOnly()).xml(subtypeModel.getXml()) : (ComposedSchema)subtypeModel;
            io.swagger.oas.models.media.Schema refSchema = new io.swagger.oas.models.media.Schema().$ref(model.getName());
            if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                composedSchema.addAllOfItem(refSchema);
            }
            this.removeParentProperties((io.swagger.oas.models.media.Schema)composedSchema, model);
            Class currentType = subtype.getType();
            context.defineModel(composedSchema.getName(), (io.swagger.oas.models.media.Schema)composedSchema, currentType, null);
        }
        return count;
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class beanClass = bean.getType().getRawClass();
        Class superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        BeanDescription superBean = this._mapper.getSerializationConfig().introspect(superType);
        List superTypes = this._intr.findSubtypes((Annotated)superBean.getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private void removeParentProperties(io.swagger.oas.models.media.Schema child, io.swagger.oas.models.media.Schema parent) {
        Map baseProps = parent.getProperties();
        Map subtypeProps = child.getProperties();
        if (baseProps != null && subtypeProps != null) {
            for (Map.Entry entry : baseProps.entrySet()) {
                if (!((io.swagger.oas.models.media.Schema)entry.getValue()).equals(subtypeProps.get(entry.getKey()))) continue;
                subtypeProps.remove(entry.getKey());
            }
        }
        if (subtypeProps.isEmpty()) {
            child.setProperties(null);
        }
    }

    private List<Class<?>> getComposedSchemaReferencedClasses(Class<?> clazz) {
        Schema schemaAnnotation = clazz.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            Class[] allOf = schemaAnnotation.allOf();
            Class[] anyOf = schemaAnnotation.anyOf();
            Class[] oneOf = schemaAnnotation.oneOf();
            List<Class<?>> parentClasses = Stream.of(allOf, anyOf, oneOf).flatMap(Stream::of).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            if (!parentClasses.isEmpty()) {
                return parentClasses;
            }
        }
        return null;
    }

    private static enum GeneratorWrapper {
        PROPERTY(ObjectIdGenerators.PropertyGenerator.class){

            @Override
            protected io.swagger.oas.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected io.swagger.oas.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                BeanDescription beanDesc = mapper.getSerializationConfig().introspect(type);
                for (BeanPropertyDefinition def : beanDesc.findProperties()) {
                    String name = def.getName();
                    if (name == null || !name.equals(propertyName)) continue;
                    AnnotatedMember propMember = def.getPrimaryMember();
                    JavaType propType = propMember.getType(beanDesc.bindingsForBeanType());
                    if (PrimitiveType.fromType((Type)propType) != null) {
                        return PrimitiveType.createProperty((Type)propType);
                    }
                    return context.resolve((Type)propType, (Annotation[])Iterables.toArray((Iterable)propMember.annotations(), Annotation.class));
                }
                return null;
            }
        }
        ,
        INT(ObjectIdGenerators.IntSequenceGenerator.class){

            @Override
            protected io.swagger.oas.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                IntegerSchema id = new IntegerSchema();
                return GeneratorWrapper.process((io.swagger.oas.models.media.Schema)id, propertyName, type, context);
            }

            @Override
            protected io.swagger.oas.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new IntegerSchema();
            }
        }
        ,
        UUID(ObjectIdGenerators.UUIDGenerator.class){

            @Override
            protected io.swagger.oas.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                UUIDSchema id = new UUIDSchema();
                return GeneratorWrapper.process((io.swagger.oas.models.media.Schema)id, propertyName, type, context);
            }

            @Override
            protected io.swagger.oas.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new UUIDSchema();
            }
        }
        ,
        NONE(ObjectIdGenerators.None.class){

            @Override
            protected io.swagger.oas.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected io.swagger.oas.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }
        };

        private final Class<? extends ObjectIdGenerator> generator;

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract io.swagger.oas.models.media.Schema processAsProperty(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract io.swagger.oas.models.media.Schema processAsId(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        public static io.swagger.oas.models.media.Schema processJsonIdentity(JavaType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static io.swagger.oas.models.media.Schema process(io.swagger.oas.models.media.Schema id, String propertyName, JavaType type, ModelConverterContext context) {
            io.swagger.oas.models.media.Schema model;
            io.swagger.oas.models.media.Schema mi = model = context.resolve((Type)type);
            mi.getProperties().put(propertyName, id);
            return new io.swagger.oas.models.media.Schema().$ref(StringUtils.isNotEmpty((CharSequence)mi.get$ref()) ? mi.get$ref() : mi.getName());
        }
    }
}

