/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class InterruptionChecker {
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private ExecutionException executionException;

    public void interrupt() {
        this.interrupted.set(true);
    }

    public boolean checkAndReturn() {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupt();
        }
        return this.interrupted.get() || this.executionException != null;
    }

    public void check() throws InterruptedException, ExecutionException {
        if (this.checkAndReturn()) {
            if (this.executionException != null) {
                throw this.executionException;
            }
            throw new InterruptedException();
        }
    }

    public ExecutionException executionException(Exception e) {
        ExecutionException newExecutionException;
        this.executionException = newExecutionException = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(e);
        return this.executionException;
    }
}

