/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.MqttConnectionException;
import io.vertx.mqtt.MqttException;
import io.vertx.mqtt.impl.MqttClientConnection;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import io.vertx.mqtt.messages.MqttMessage;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubAckMessage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MqttClientImpl
implements MqttClient {
    private static final Logger log = LoggerFactory.getLogger(MqttClientImpl.class);
    private static final int MAX_MESSAGE_ID = 65535;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final int MIN_TOPIC_LEN = 1;
    private static final String PROTOCOL_NAME = "MQTT";
    private static final int PROTOCOL_VERSION = 4;
    private MqttClientOptions options;
    private MqttClientConnection connection;
    private final NetClient client;
    Handler<Integer> publishCompletionHandler;
    Handler<Integer> unsubscribeCompletionHandler;
    Handler<MqttPublishMessage> publishHandler;
    Handler<MqttSubAckMessage> subscribeCompletionHandler;
    Handler<AsyncResult<MqttConnAckMessage>> connectHandler;
    Handler<Void> pingrespHandler;
    Handler<Throwable> exceptionHandler;
    Handler<Void> closeHandler;
    LinkedHashMap<Integer, io.netty.handler.codec.mqtt.MqttMessage> qos1outbound = new LinkedHashMap();
    LinkedHashMap<Integer, io.netty.handler.codec.mqtt.MqttMessage> qos2outbound = new LinkedHashMap();
    LinkedHashMap<Integer, MqttMessage> qos2inbound = new LinkedHashMap();
    private int messageIdCounter;
    private int countInflightQueue;
    private Pattern validTopicNamePattern = Pattern.compile("^[^#+\\u0000]+$");
    private Pattern validTopicFilterPattern = Pattern.compile("^(#|((\\+(?![^/]))?([^#+]*(/\\+(?![^/]))?)*(/#)?))$");

    public MqttClientImpl(Vertx vertx, MqttClientOptions options) {
        this.client = vertx.createNetClient((NetClientOptions)options);
        this.options = options;
    }

    @Override
    public MqttClient connect(int port, String host, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.doConnect(port, host, null, connectHandler);
        return this;
    }

    @Override
    public MqttClient connect(int port, String host, String serverName, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.doConnect(port, host, serverName, connectHandler);
        return this;
    }

    private void doConnect(int port, String host, String serverName, Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        log.debug((Object)String.format("Trying to connect with %s:%d", host, port));
        this.client.connect(port, host, serverName, done -> {
            if (done.failed()) {
                log.error((Object)String.format("Can't connect to %s:%d", host, port), done.cause());
                if (connectHandler != null) {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)done.cause()));
                }
            } else {
                log.info((Object)String.format("Connection with %s:%d established successfully", host, port));
                NetSocketInternal soi = (NetSocketInternal)done.result();
                ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
                this.connectHandler = connectHandler;
                if (this.options.isAutoGeneratedClientId() && (this.options.getClientId() == null || this.options.getClientId().isEmpty())) {
                    this.options.setClientId(this.generateRandomClientId());
                }
                this.initChannel(pipeline);
                this.connection = new MqttClientConnection(this, soi, this.options);
                soi.messageHandler(msg -> this.connection.handleMessage(msg));
                soi.closeHandler(v -> this.handleClosed());
                soi.exceptionHandler(this::handleException);
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttConnectVariableHeader variableHeader = new MqttConnectVariableHeader(PROTOCOL_NAME, 4, this.options.hasUsername(), this.options.hasPassword(), this.options.isWillRetain(), this.options.getWillQoS(), this.options.isWillFlag(), this.options.isCleanSession(), this.options.getKeepAliveTimeSeconds());
                MqttConnectPayload payload = new MqttConnectPayload(this.options.getClientId() == null ? "" : this.options.getClientId(), this.options.getWillTopic(), this.options.getWillMessage() != null ? this.options.getWillMessage().getBytes(StandardCharsets.UTF_8) : null, this.options.hasUsername() ? this.options.getUsername() : null, this.options.hasPassword() ? this.options.getPassword().getBytes() : null);
                io.netty.handler.codec.mqtt.MqttMessage connect = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
                this.write(connect);
            }
        });
    }

    @Override
    public MqttClient disconnect() {
        return this.disconnect(null);
    }

    @Override
    public MqttClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
        io.netty.handler.codec.mqtt.MqttMessage disconnect = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, null, null);
        this.write(disconnect);
        if (disconnectHandler != null) {
            disconnectHandler.handle((Object)Future.succeededFuture());
        }
        this.connection.close();
        return this;
    }

    @Override
    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return this.publish(topic, payload, qosLevel, isDup, isRetain, null);
    }

    @Override
    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        if (this.countInflightQueue >= this.options.getMaxInflightQueue()) {
            String msg = String.format("Attempt to exceed the limit of %d inflight messages", this.options.getMaxInflightQueue());
            log.error((Object)msg);
            MqttException exception = new MqttException(2, msg);
            if (publishSentHandler != null) {
                publishSentHandler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return this;
        }
        if (!this.isValidTopicName(topic)) {
            String msg = String.format("Invalid Topic Name - %s. It mustn't contains wildcards: # and +. Also it can't contains U+0000(NULL) chars", topic);
            log.error((Object)msg);
            MqttException exception = new MqttException(0, msg);
            if (publishSentHandler != null) {
                publishSentHandler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return this;
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, isDup, qosLevel, isRetain, 0);
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, this.nextMessageId());
        ByteBuf buf = Unpooled.copiedBuffer((byte[])payload.getBytes());
        io.netty.handler.codec.mqtt.MqttMessage publish = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)buf);
        switch (qosLevel) {
            case AT_LEAST_ONCE: {
                this.qos1outbound.put(variableHeader.messageId(), publish);
                ++this.countInflightQueue;
                break;
            }
            case EXACTLY_ONCE: {
                this.qos2outbound.put(variableHeader.messageId(), publish);
                ++this.countInflightQueue;
            }
        }
        this.write(publish);
        if (publishSentHandler != null) {
            publishSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.messageId()));
        }
        return this;
    }

    @Override
    public MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.publishCompletionHandler = publishCompletionHandler;
        return this;
    }

    @Override
    public MqttClient publishHandler(Handler<MqttPublishMessage> publishHandler) {
        this.publishHandler = publishHandler;
        return this;
    }

    @Override
    public MqttClient subscribeCompletionHandler(Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.subscribeCompletionHandler = subscribeCompletionHandler;
        return this;
    }

    @Override
    public MqttClient subscribe(String topic, int qos) {
        return this.subscribe(topic, qos, null);
    }

    @Override
    public MqttClient subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        return this.subscribe(Collections.singletonMap(topic, qos), subscribeSentHandler);
    }

    @Override
    public MqttClient subscribe(Map<String, Integer> topics) {
        return this.subscribe(topics, null);
    }

    @Override
    public MqttClient subscribe(Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        Map<String, Integer> invalidTopics = topics.entrySet().stream().filter(e -> !this.isValidTopicFilter((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (invalidTopics.size() > 0) {
            String msg = String.format("Invalid Topic Filters: %s", invalidTopics);
            log.error((Object)msg);
            MqttException exception = new MqttException(1, msg);
            if (subscribeSentHandler != null) {
                subscribeSentHandler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return this;
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)this.nextMessageId());
        List subscriptions = topics.entrySet().stream().map(e -> new MqttTopicSubscription((String)e.getKey(), MqttQoS.valueOf((int)((Integer)e.getValue())))).collect(Collectors.toList());
        MqttSubscribePayload payload = new MqttSubscribePayload(subscriptions);
        io.netty.handler.codec.mqtt.MqttMessage subscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(subscribe);
        if (subscribeSentHandler != null) {
            subscribeSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.messageId()));
        }
        return this;
    }

    @Override
    public MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.unsubscribeCompletionHandler = unsubscribeCompletionHandler;
        return this;
    }

    @Override
    public MqttClient unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)this.nextMessageId());
        MqttUnsubscribePayload payload = new MqttUnsubscribePayload(Stream.of(topic).collect(Collectors.toList()));
        io.netty.handler.codec.mqtt.MqttMessage unsubscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(unsubscribe);
        if (unsubscribeSentHandler != null) {
            unsubscribeSentHandler.handle((Object)Future.succeededFuture((Object)variableHeader.messageId()));
        }
        return this;
    }

    @Override
    public MqttClient unsubscribe(String topic) {
        return this.unsubscribe(topic, null);
    }

    @Override
    public MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.pingrespHandler = pingResponseHandler;
        return this;
    }

    @Override
    public MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public MqttClient closeHandler(Handler<Void> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public MqttClient ping() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGREQ, false, MqttQoS.AT_MOST_ONCE, false, 0);
        io.netty.handler.codec.mqtt.MqttMessage pingreq = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, null, null);
        this.write(pingreq);
        return this;
    }

    @Override
    public String clientId() {
        return this.options.getClientId();
    }

    void publishAcknowledge(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage puback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(puback);
    }

    void publishReceived(MqttPublishMessage publishMessage) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessage.messageId());
        io.netty.handler.codec.mqtt.MqttMessage pubrec = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.qos2inbound.put(publishMessage.messageId(), publishMessage);
        this.write(pubrec);
    }

    void publishComplete(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage pubcomp = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(pubcomp);
    }

    void publishRelease(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        io.netty.handler.codec.mqtt.MqttMessage pubrel = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.qos2outbound.put(publishMessageId, pubrel);
        this.write(pubrel);
    }

    private void initChannel(ChannelPipeline pipeline) {
        pipeline.addBefore("handler", "mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
        if (this.options.getMaxMessageSize() > 0) {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder(this.options.getMaxMessageSize()));
        } else {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder());
        }
        if (this.options.isAutoKeepAlive() && this.options.getKeepAliveTimeSeconds() != 0) {
            pipeline.addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(0, this.options.getKeepAliveTimeSeconds(), 0));
            pipeline.addBefore("handler", "keepAliveHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    IdleStateEvent e;
                    if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
                        MqttClientImpl.this.ping();
                    }
                }
            });
        }
    }

    private int nextMessageId() {
        this.messageIdCounter = this.messageIdCounter % 65535 != 0 ? this.messageIdCounter + 1 : 1;
        return this.messageIdCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttClientImpl write(io.netty.handler.codec.mqtt.MqttMessage mqttMessage) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            log.debug((Object)String.format("Sending packet %s", mqttMessage));
            this.connection.writeMessage(mqttMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClosed() {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.closeHandler != null) {
                this.closeHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePingresp() {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.pingrespHandler != null) {
                this.pingrespHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsuback(int unsubackMessageId) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.unsubscribeCompletionHandler != null) {
                this.unsubscribeCompletionHandler.handle((Object)unsubackMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePuback(int pubackMessageId) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            io.netty.handler.codec.mqtt.MqttMessage removedPacket = (io.netty.handler.codec.mqtt.MqttMessage)this.qos1outbound.remove(pubackMessageId);
            if (removedPacket == null) {
                log.warn((Object)"Received PUBACK packet without having related PUBLISH packet in storage");
                return;
            }
            --this.countInflightQueue;
            if (this.publishCompletionHandler != null) {
                this.publishCompletionHandler.handle((Object)pubackMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubcomp(int pubcompMessageId) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            io.netty.handler.codec.mqtt.MqttMessage removedPacket = (io.netty.handler.codec.mqtt.MqttMessage)this.qos2outbound.remove(pubcompMessageId);
            if (removedPacket == null) {
                log.warn((Object)"Received PUBCOMP packet without having related PUBREL packet in storage");
                return;
            }
            --this.countInflightQueue;
            if (this.publishCompletionHandler != null) {
                this.publishCompletionHandler.handle((Object)pubcompMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrec(int pubrecMessageId) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            this.publishRelease(pubrecMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSuback(MqttSubAckMessage msg) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.subscribeCompletionHandler != null) {
                this.subscribeCompletionHandler.handle((Object)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePublish(MqttPublishMessage msg) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            switch (msg.qosLevel()) {
                case AT_MOST_ONCE: {
                    if (this.publishHandler == null) break;
                    this.publishHandler.handle((Object)msg);
                    break;
                }
                case AT_LEAST_ONCE: {
                    this.publishAcknowledge(msg.messageId());
                    if (this.publishHandler == null) break;
                    this.publishHandler.handle((Object)msg);
                    break;
                }
                case EXACTLY_ONCE: {
                    this.publishReceived(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrel(int pubrelMessageId) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            MqttMessage message = this.qos2inbound.get(pubrelMessageId);
            if (message == null) {
                log.warn((Object)"Received PUBREL packet without having related PUBREC packet in storage");
                return;
            }
            if (this.publishHandler != null) {
                this.publishHandler.handle((Object)((MqttPublishMessage)message));
            }
            this.publishComplete(pubrelMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnack(MqttConnAckMessage msg) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.connectHandler != null) {
                if (msg.code() == MqttConnectReturnCode.CONNECTION_ACCEPTED) {
                    this.connectHandler.handle((Object)Future.succeededFuture((Object)msg));
                } else {
                    MqttConnectionException exception = new MqttConnectionException(msg.code());
                    log.error((Object)"Connection refused by the server");
                    this.connectHandler.handle((Object)Future.failedFuture((Throwable)exception));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        MqttClientConnection mqttClientConnection = this.connection;
        synchronized (mqttClientConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle((Object)t);
            }
        }
    }

    private String generateRandomClientId() {
        return UUID.randomUUID().toString();
    }

    private boolean isValidTopicName(String topicName) {
        if (!this.isValidStringSizeInUTF8(topicName)) {
            return false;
        }
        Matcher matcher = this.validTopicNamePattern.matcher(topicName);
        return matcher.find();
    }

    private boolean isValidTopicFilter(String topicFilter) {
        if (!this.isValidStringSizeInUTF8(topicFilter)) {
            return false;
        }
        Matcher matcher = this.validTopicFilterPattern.matcher(topicFilter);
        return matcher.find();
    }

    private boolean isValidStringSizeInUTF8(String string) {
        try {
            int length = string.getBytes("UTF-8").length;
            return length >= 1 && length <= 65535;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"UTF-8 charset is not supported", (Throwable)e);
            return false;
        }
    }
}

