/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.impl.MqttEndpointImpl;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;
import java.util.UUID;

public class MqttServerConnection {
    private Handler<MqttEndpoint> endpointHandler;
    private Handler<Throwable> exceptionHandler;
    private final NetSocketInternal so;
    private MqttEndpointImpl endpoint;
    private final ChannelHandlerContext chctx;
    private final MqttServerOptions options;

    void init(Handler<MqttEndpoint> endpointHandler, Handler<Throwable> rejectHandler) {
        this.endpointHandler = endpointHandler;
        this.exceptionHandler = rejectHandler;
    }

    public MqttServerConnection(NetSocketInternal so, MqttServerOptions options) {
        this.so = so;
        this.chctx = so.channelHandlerContext();
        this.options = options;
    }

    synchronized void handleMessage(Object msg) {
        if (msg instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)msg;
            DecoderResult result = mqttMessage.decoderResult();
            if (result.isFailure()) {
                this.chctx.pipeline().fireExceptionCaught(result.cause());
                return;
            }
            if (!result.isFinished()) {
                this.chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Unfinished message"));
                return;
            }
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNECT: {
                    this.handleConnect((MqttConnectMessage)msg);
                    break;
                }
                case SUBSCRIBE: {
                    MqttSubscribeMessage subscribe = (MqttSubscribeMessage)mqttMessage;
                    io.vertx.mqtt.messages.MqttSubscribeMessage mqttSubscribeMessage = io.vertx.mqtt.messages.MqttSubscribeMessage.create(subscribe.variableHeader().messageId(), subscribe.payload().topicSubscriptions());
                    this.handleSubscribe(mqttSubscribeMessage);
                    break;
                }
                case UNSUBSCRIBE: {
                    io.netty.handler.codec.mqtt.MqttUnsubscribeMessage unsubscribe = (io.netty.handler.codec.mqtt.MqttUnsubscribeMessage)mqttMessage;
                    MqttUnsubscribeMessage mqttUnsubscribeMessage = MqttUnsubscribeMessage.create(unsubscribe.variableHeader().messageId(), unsubscribe.payload().topics());
                    this.handleUnsubscribe(mqttUnsubscribeMessage);
                    break;
                }
                case PUBLISH: {
                    MqttPublishMessage publish = (MqttPublishMessage)mqttMessage;
                    ByteBuf newBuf = VertxHandler.safeBuffer((ByteBuf)publish.payload(), (ByteBufAllocator)this.chctx.alloc());
                    io.vertx.mqtt.messages.MqttPublishMessage mqttPublishMessage = io.vertx.mqtt.messages.MqttPublishMessage.create(publish.variableHeader().messageId(), publish.fixedHeader().qosLevel(), publish.fixedHeader().isDup(), publish.fixedHeader().isRetain(), publish.variableHeader().topicName(), newBuf);
                    this.handlePublish(mqttPublishMessage);
                    break;
                }
                case PUBACK: {
                    MqttPubAckMessage mqttPubackMessage = (MqttPubAckMessage)mqttMessage;
                    this.handlePuback(mqttPubackMessage.variableHeader().messageId());
                    break;
                }
                case PUBREC: {
                    int pubrecMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrec(pubrecMessageId);
                    break;
                }
                case PUBREL: {
                    int pubrelMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrel(pubrelMessageId);
                    break;
                }
                case PUBCOMP: {
                    int pubcompMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubcomp(pubcompMessageId);
                    break;
                }
                case PINGREQ: {
                    this.handlePingreq();
                    break;
                }
                case DISCONNECT: {
                    this.handleDisconnect();
                    break;
                }
                default: {
                    this.chctx.fireExceptionCaught((Throwable)new Exception("Wrong message type " + msg.getClass().getName()));
                    break;
                }
            }
        } else {
            this.chctx.fireExceptionCaught((Throwable)new Exception("Wrong message type"));
        }
    }

    private void handleConnect(MqttConnectMessage msg) {
        if (this.endpoint != null) {
            this.endpoint.close();
            return;
        }
        if (this.endpoint != null) {
            this.endpoint.close();
            return;
        }
        MqttWill will = new MqttWill(msg.variableHeader().isWillFlag(), msg.payload().willTopic(), msg.payload().willMessage(), msg.variableHeader().willQos(), msg.variableHeader().isWillRetain());
        MqttAuth auth = msg.variableHeader().hasUserName() && msg.variableHeader().hasPassword() ? new MqttAuth(msg.payload().userName(), msg.payload().password()) : null;
        boolean isZeroBytes = msg.payload().clientIdentifier() == null || msg.payload().clientIdentifier().isEmpty();
        String clientIdentifier = null;
        if (!isZeroBytes) {
            clientIdentifier = msg.payload().clientIdentifier();
        } else if (this.options.isAutoClientId()) {
            clientIdentifier = UUID.randomUUID().toString();
        }
        this.endpoint = new MqttEndpointImpl(this.so, clientIdentifier, auth, will, msg.variableHeader().isCleanSession(), msg.variableHeader().version(), msg.variableHeader().name(), msg.variableHeader().keepAliveTimeSeconds());
        this.chctx.pipeline().remove("idle");
        this.chctx.pipeline().remove("timeoutOnConnect");
        if (msg.variableHeader().keepAliveTimeSeconds() != 0) {
            int timeout = msg.variableHeader().keepAliveTimeSeconds() + msg.variableHeader().keepAliveTimeSeconds() / 2;
            this.chctx.pipeline().addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(timeout, 0, 0));
            this.chctx.pipeline().addBefore("handler", "keepAliveHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    IdleStateEvent e;
                    if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                        MqttServerConnection.this.endpoint.close();
                    }
                }
            });
        }
        if (isZeroBytes && !msg.variableHeader().isCleanSession()) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle((Object)new VertxException("With zero-length client-id, clean session MUST be true"));
            }
            this.endpoint.reject(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
        } else {
            this.so.exceptionHandler(t -> this.endpoint.handleException((Throwable)t));
            this.so.closeHandler(v -> this.endpoint.handleClosed());
            this.endpointHandler.handle((Object)this.endpoint);
        }
    }

    synchronized void handleSubscribe(io.vertx.mqtt.messages.MqttSubscribeMessage msg) {
        if (this.checkConnected()) {
            this.endpoint.handleSubscribe(msg);
        }
    }

    synchronized void handleUnsubscribe(MqttUnsubscribeMessage msg) {
        if (this.checkConnected()) {
            this.endpoint.handleUnsubscribe(msg);
        }
    }

    synchronized void handlePublish(io.vertx.mqtt.messages.MqttPublishMessage msg) {
        if (this.checkConnected()) {
            this.endpoint.handlePublish(msg);
        }
    }

    synchronized void handlePuback(int pubackMessageId) {
        if (this.checkConnected()) {
            this.endpoint.handlePuback(pubackMessageId);
        }
    }

    synchronized void handlePubrec(int pubrecMessageId) {
        if (this.checkConnected()) {
            this.endpoint.handlePubrec(pubrecMessageId);
        }
    }

    synchronized void handlePubrel(int pubrelMessageId) {
        if (this.checkConnected()) {
            this.endpoint.handlePubrel(pubrelMessageId);
        }
    }

    synchronized void handlePubcomp(int pubcompMessageId) {
        if (this.checkConnected()) {
            this.endpoint.handlePubcomp(pubcompMessageId);
        }
    }

    synchronized void handlePingreq() {
        if (this.checkConnected()) {
            this.endpoint.handlePingreq();
        }
    }

    synchronized void handleDisconnect() {
        if (this.checkConnected()) {
            this.endpoint.handleDisconnect();
        }
    }

    private boolean checkConnected() {
        if (this.endpoint != null && this.endpoint.isConnected()) {
            return true;
        }
        this.so.close();
        throw new IllegalStateException("Received an MQTT packet from a not connected client (CONNECT not sent yet)");
    }
}

