/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import rx.Observable;
import rx.Subscriber;

public abstract class UnmarshallerOperator<T, B>
implements Observable.Operator<T, B> {
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;

    public UnmarshallerOperator(Class<T> mappedType) {
        this.mappedType = mappedType;
        this.mappedTypeRef = null;
    }

    public UnmarshallerOperator(TypeReference<T> mappedTypeRef) {
        this.mappedType = null;
        this.mappedTypeRef = mappedTypeRef;
    }

    public abstract Buffer unwrap(B var1);

    public Subscriber<? super B> call(final Subscriber<? super T> subscriber) {
        final Buffer buffer = Buffer.buffer();
        return new Subscriber<B>(subscriber){

            public void onCompleted() {
                try {
                    Object obj = null;
                    if (buffer.length() > 0) {
                        obj = Objects.nonNull(UnmarshallerOperator.this.mappedType) ? Json.mapper.readValue(buffer.getBytes(), UnmarshallerOperator.this.mappedType) : Json.mapper.readValue(buffer.getBytes(), UnmarshallerOperator.this.mappedTypeRef);
                    }
                    subscriber.onNext(obj);
                    subscriber.onCompleted();
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onNext(B item) {
                buffer.appendBuffer(UnmarshallerOperator.this.unwrap(item));
            }
        };
    }
}

