/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.datagram;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.datagram.DatagramPacket;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg<DatagramSocket>(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private Observable<DatagramPacket> observable;
    private SocketAddress cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<DatagramPacket> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public DatagramSocket send(Buffer packet, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(packet.getDelegate(), port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> sendObservable(Buffer packet, int port, String host) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.send(packet, port, host, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxSend(Buffer packet, int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(packet, port, host, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), Buffer.__TYPE_ARG);
        return ret;
    }

    public DatagramSocket send(String str, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> sendObservable(String str, int port, String host) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.send(str, port, host, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxSend(String str, int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(str, port, host, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket send(String str, String enc, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, enc, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> sendObservable(String str, String enc, int port, String host) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.send(str, enc, port, host, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxSend(String str, String enc, int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(str, enc, port, host, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.close(handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> listenMulticastGroupObservable(String multicastAddress) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.listenMulticastGroup(multicastAddress, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxListenMulticastGroup(String multicastAddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> listenMulticastGroupObservable(String multicastAddress, String networkInterface, String source) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.listenMulticastGroup(multicastAddress, networkInterface, source, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> unlistenMulticastGroupObservable(String multicastAddress) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.unlistenMulticastGroup(multicastAddress, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unlistenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> unlistenMulticastGroupObservable(String multicastAddress, String networkInterface, String source) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> blockMulticastGroupObservable(String multicastAddress, String sourceToBlock) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.blockMulticastGroup(multicastAddress, sourceToBlock, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> blockMulticastGroupObservable(String multicastAddress, String networkInterface, String sourceToBlock) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket listen(int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<DatagramSocket> listenObservable(int port, String host) {
        ObservableFuture<DatagramSocket> handler = RxHelper.observableFuture();
        this.listen(port, host, handler.toHandler());
        return handler;
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listen(port, host, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    public DatagramSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public DatagramSocket handler(final Handler<DatagramPacket> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.datagram.DatagramPacket>(){

            public void handle(io.vertx.core.datagram.DatagramPacket event) {
                handler.handle((Object)DatagramPacket.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

