/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.WebSocket;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg<HttpClient>(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, options));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, port, host, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, host, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, absoluteURI));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest get(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(options));
        return ret;
    }

    public HttpClientRequest get(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest get(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(host, requestURI));
        return ret;
    }

    public HttpClientRequest get(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest get(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest get(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest get(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(requestURI));
        return ret;
    }

    public HttpClientRequest get(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest getAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.getAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest getAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.getAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClient getNow(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.getNow(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient getNow(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.getNow(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient getNow(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.getNow(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient getNow(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.getNow(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest post(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(options));
        return ret;
    }

    public HttpClientRequest post(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest post(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(host, requestURI));
        return ret;
    }

    public HttpClientRequest post(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest post(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest post(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest post(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(requestURI));
        return ret;
    }

    public HttpClientRequest post(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest postAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.postAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest postAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.postAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest head(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(options));
        return ret;
    }

    public HttpClientRequest head(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest head(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(host, requestURI));
        return ret;
    }

    public HttpClientRequest head(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest head(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest head(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest head(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(requestURI));
        return ret;
    }

    public HttpClientRequest head(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest headAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.headAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest headAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.headAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClient headNow(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.headNow(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient headNow(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.headNow(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient headNow(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.headNow(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient headNow(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.headNow(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest options(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(options));
        return ret;
    }

    public HttpClientRequest options(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest options(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(host, requestURI));
        return ret;
    }

    public HttpClientRequest options(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest options(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest options(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest options(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(requestURI));
        return ret;
    }

    public HttpClientRequest options(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest optionsAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.optionsAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest optionsAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.optionsAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClient optionsNow(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.optionsNow(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient optionsNow(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.optionsNow(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient optionsNow(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.optionsNow(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient optionsNow(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        this.delegate.optionsNow(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest put(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(options));
        return ret;
    }

    public HttpClientRequest put(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest put(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(host, requestURI));
        return ret;
    }

    public HttpClientRequest put(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest put(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest put(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest put(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(requestURI));
        return ret;
    }

    public HttpClientRequest put(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest putAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.putAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest putAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.putAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(options));
        return ret;
    }

    public HttpClientRequest delete(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest delete(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(host, requestURI));
        return ret;
    }

    public HttpClientRequest delete(RequestOptions options, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(options, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(int port, String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(String host, String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(host, requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(requestURI));
        return ret;
    }

    public HttpClientRequest delete(String requestURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(requestURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClientRequest deleteAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.deleteAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest deleteAbs(String absoluteURI, final Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.deleteAbs(absoluteURI, (Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                responseHandler.handle((Object)HttpClientResponse.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpClient websocket(RequestOptions options, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(options, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(RequestOptions options, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(options, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(port, host, requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String host, String requestURI, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(host, requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String host, String requestURI, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(host, requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(options, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(options, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(options, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(options, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(options, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocketAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocketAbs(url, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(options, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(port, host, requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(host, requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String requestURI, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String requestURI, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(requestURI, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(requestURI, headers.getDelegate(), (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(requestURI, headers.getDelegate(), version, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect) {
        this.delegate.websocket(requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, final Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.delegate.websocket(requestURI, headers.getDelegate(), version, subProtocols, (Handler)new Handler<io.vertx.core.http.WebSocket>(){

            public void handle(io.vertx.core.http.WebSocket event) {
                wsConnect.handle((Object)WebSocket.newInstance(event));
            }
        }, failureHandler);
        return this;
    }

    public ReadStream<WebSocket> websocketStream(RequestOptions options) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(options), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(int port, String host, String requestURI) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(port, host, requestURI), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String host, String requestURI) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(host, requestURI), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(RequestOptions options, MultiMap headers) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(options, headers.getDelegate()), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(int port, String host, String requestURI, MultiMap headers) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(port, host, requestURI, headers.getDelegate()), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String host, String requestURI, MultiMap headers) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(host, requestURI, headers.getDelegate()), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(RequestOptions options, MultiMap headers, WebsocketVersion version) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(options, headers.getDelegate(), version), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(port, host, requestURI, headers.getDelegate(), version), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(host, requestURI, headers.getDelegate(), version), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStreamAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStreamAbs(url, headers.getDelegate(), version, subProtocols), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(options, headers.getDelegate(), version, subProtocols), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(port, host, requestURI, headers.getDelegate(), version, subProtocols), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(host, requestURI, headers.getDelegate(), version, subProtocols), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String requestURI) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(requestURI), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String requestURI, MultiMap headers) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(requestURI, headers.getDelegate()), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String requestURI, MultiMap headers, WebsocketVersion version) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(requestURI, headers.getDelegate(), version), WebSocket.__TYPE_ARG);
        return ret;
    }

    public ReadStream<WebSocket> websocketStream(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        ReadStream<WebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(requestURI, headers.getDelegate(), version, subProtocols), WebSocket.__TYPE_ARG);
        return ret;
    }

    public HttpClient redirectHandler(final Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public io.vertx.core.Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

