/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.util.List;

@VertxGen
public interface SQLConnection
extends SQLOperations,
AutoCloseable {
    @Fluent
    public SQLConnection setOptions(SQLOptions var1);

    @Fluent
    public SQLConnection setAutoCommit(boolean var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public SQLConnection execute(String var1, Handler<AsyncResult<Void>> var2);

    @Override
    @Fluent
    public SQLConnection query(String var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public SQLConnection queryStream(String var1, Handler<AsyncResult<SQLRowStream>> var2);

    @Override
    @Fluent
    public SQLConnection queryWithParams(String var1, JsonArray var2, Handler<AsyncResult<ResultSet>> var3);

    @Fluent
    public SQLConnection queryStreamWithParams(String var1, JsonArray var2, Handler<AsyncResult<SQLRowStream>> var3);

    @Override
    @Fluent
    public SQLConnection update(String var1, Handler<AsyncResult<UpdateResult>> var2);

    @Override
    @Fluent
    public SQLConnection updateWithParams(String var1, JsonArray var2, Handler<AsyncResult<UpdateResult>> var3);

    @Fluent
    public SQLConnection call(String var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public SQLConnection callWithParams(String var1, JsonArray var2, JsonArray var3, Handler<AsyncResult<ResultSet>> var4);

    public void close(Handler<AsyncResult<Void>> var1);

    @Override
    public void close();

    @Fluent
    public SQLConnection commit(Handler<AsyncResult<Void>> var1);

    @Fluent
    public SQLConnection rollback(Handler<AsyncResult<Void>> var1);

    @Fluent
    @Deprecated
    default public SQLConnection setQueryTimeout(int timeoutInSeconds) {
        this.setOptions(new SQLOptions().setQueryTimeout(timeoutInSeconds));
        return this;
    }

    @Fluent
    public SQLConnection batch(List<String> var1, Handler<AsyncResult<List<Integer>>> var2);

    @Fluent
    public SQLConnection batchWithParams(String var1, List<JsonArray> var2, Handler<AsyncResult<List<Integer>>> var3);

    @Fluent
    public SQLConnection batchCallableWithParams(String var1, List<JsonArray> var2, List<JsonArray> var3, Handler<AsyncResult<List<Integer>>> var4);

    @Fluent
    public SQLConnection setTransactionIsolation(TransactionIsolation var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> var1);

    @GenIgnore
    default public <N> N unwrap() {
        return null;
    }
}

