/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.repository.RepositorySystem;

public class MavenArtifactResolver {
    public static final String POM = "pom";
    public static final String JAR = "jar";
    private final RepositorySystem repositorySystem;
    private final MavenSession session;

    public MavenArtifactResolver(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = repositorySystem;
        this.session = session;
    }

    public Artifact getJar(String groupId, String artifactId, String version, String classifier) {
        Artifact artifact = this.createJarArtifact(groupId, artifactId, version, classifier);
        Set<Artifact> resolvedArtifacts = this.resolve(artifact, false);
        if (resolvedArtifacts.isEmpty()) {
            throw new NoSuchElementException(String.format("Could not resolve artifact %s:%s:%s:%s", groupId, artifactId, version, classifier));
        }
        return resolvedArtifacts.iterator().next();
    }

    public Set<Artifact> getJarAndDependencies(String groupId, String artifactId, String version, String classifier) {
        Artifact artifact = this.createJarArtifact(groupId, artifactId, version, classifier);
        return this.resolve(artifact, true);
    }

    private Artifact createJarArtifact(String groupId, String artifactId, String version, String classifier) {
        return classifier == null ? this.repositorySystem.createArtifact(groupId, artifactId, version, JAR) : this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, JAR, classifier);
    }

    private Set<Artifact> resolve(Artifact artifact, boolean transitively) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(transitively).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repositorySystem.resolve(request).getArtifacts();
    }
}

