/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sdk.alipay.controller;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import java.util.HashMap;
import java.util.Map;
import net.guerlab.sdk.alipay.config.AlipayConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AlipayAbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlipayAbstractController.class);
    protected static final String TYPE = "ALIPAY";
    @Autowired
    protected AlipayConfig config;

    protected final boolean notify0(Map<String, String[]> requestParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String name : requestParams.keySet()) {
            String[] values = requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }
        try {
            return AlipaySignature.rsaCheckV1(params, (String)this.config.getAlipayPublicKey(), (String)"UTF-8", (String)"RSA2");
        }
        catch (AlipayApiException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

