/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.text.ParseException;
import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.DateSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;

public class DateBetween<T>
extends DateSpecification<T> {
    private Date after;
    private Date before;

    public DateBetween(String path, String[] args, Converter converter) throws ParseException {
        super(path, args, converter);
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("expected 2 http params (date boundaries), but was: " + args);
        }
        String afterDateStr = args[0];
        String beforeDateStr = args[1];
        this.after = converter.convertToDate(afterDateStr);
        this.before = converter.convertToDate(beforeDateStr);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        return cb.between(this.path(root), (Comparable)this.after, (Comparable)this.before);
    }
}

