/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.StopWatch;

public class DirectVmBlockingProducer
extends DefaultAsyncProducer {
    private final DirectVmEndpoint endpoint;

    public DirectVmBlockingProducer(DirectVmEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        this.getConsumer(exchange).getProcessor().process(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.getConsumer(exchange).getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected DirectVmConsumer getConsumer(Exchange exchange) throws Exception {
        DirectVmConsumer answer = this.endpoint.getConsumer();
        if (answer == null && (answer = this.awaitConsumer()) == null) {
            throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange);
        }
        return answer;
    }

    private DirectVmConsumer awaitConsumer() throws InterruptedException {
        DirectVmConsumer answer = null;
        StopWatch watch = new StopWatch();
        boolean done = false;
        while (!done) {
            Thread.sleep(500L);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Waited {} for consumer to be ready", (Object)watch.taken());
            }
            if ((answer = this.endpoint.getConsumer()) != null) {
                return answer;
            }
            done = watch.taken() >= this.endpoint.getTimeout();
        }
        return answer;
    }
}

