/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.flink.formats.avro.SchemaCoder;

public class ConfluentSchemaRegistryCoder
implements SchemaCoder {
    private final SchemaRegistryClient schemaRegistryClient;

    public ConfluentSchemaRegistryCoder(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
    }

    public Schema readSchema(InputStream in) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(in);
        if (dataInputStream.readByte() != 0) {
            throw new IOException("Unknown data format. Magic number does not match");
        }
        int schemaId = dataInputStream.readInt();
        try {
            return this.schemaRegistryClient.getById(schemaId);
        }
        catch (RestClientException e) {
            throw new IOException(String.format("Could not find schema with id %s in registry", schemaId), e);
        }
    }
}

