/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent.shaded.org.apache.jute;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeMap;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.apache.jute.OutputArchive;
import org.apache.flink.formats.avro.registry.confluent.shaded.org.apache.jute.Record;

public class BinaryOutputArchive
implements OutputArchive {
    private ByteBuffer bb = ByteBuffer.allocate(1024);
    private DataOutput out;

    public static BinaryOutputArchive getArchive(OutputStream strm) {
        return new BinaryOutputArchive(new DataOutputStream(strm));
    }

    public BinaryOutputArchive(DataOutput out) {
        this.out = out;
    }

    @Override
    public void writeByte(byte b, String tag) throws IOException {
        this.out.writeByte(b);
    }

    @Override
    public void writeBool(boolean b, String tag) throws IOException {
        this.out.writeBoolean(b);
    }

    @Override
    public void writeInt(int i, String tag) throws IOException {
        this.out.writeInt(i);
    }

    @Override
    public void writeLong(long l, String tag) throws IOException {
        this.out.writeLong(l);
    }

    @Override
    public void writeFloat(float f, String tag) throws IOException {
        this.out.writeFloat(f);
    }

    @Override
    public void writeDouble(double d, String tag) throws IOException {
        this.out.writeDouble(d);
    }

    private final ByteBuffer stringToByteBuffer(CharSequence s) {
        this.bb.clear();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c;
            if (this.bb.remaining() < 3) {
                ByteBuffer n = ByteBuffer.allocate(this.bb.capacity() << 1);
                this.bb.flip();
                n.put(this.bb);
                this.bb = n;
            }
            if ((c = s.charAt(i)) < '\u0080') {
                this.bb.put((byte)c);
                continue;
            }
            if (c < '\u0800') {
                this.bb.put((byte)(0xC0 | c >> 6));
                this.bb.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            this.bb.put((byte)(0xE0 | c >> 12));
            this.bb.put((byte)(0x80 | c >> 6 & 0x3F));
            this.bb.put((byte)(0x80 | c & 0x3F));
        }
        this.bb.flip();
        return this.bb;
    }

    @Override
    public void writeString(String s, String tag) throws IOException {
        if (s == null) {
            this.writeInt(-1, "len");
            return;
        }
        ByteBuffer bb = this.stringToByteBuffer(s);
        this.writeInt(bb.remaining(), "len");
        this.out.write(bb.array(), bb.position(), bb.limit());
    }

    @Override
    public void writeBuffer(byte[] barr, String tag) throws IOException {
        if (barr == null) {
            this.out.writeInt(-1);
            return;
        }
        this.out.writeInt(barr.length);
        this.out.write(barr);
    }

    @Override
    public void writeRecord(Record r, String tag) throws IOException {
        r.serialize(this, tag);
    }

    @Override
    public void startRecord(Record r, String tag) throws IOException {
    }

    @Override
    public void endRecord(Record r, String tag) throws IOException {
    }

    @Override
    public void startVector(List v, String tag) throws IOException {
        if (v == null) {
            this.writeInt(-1, tag);
            return;
        }
        this.writeInt(v.size(), tag);
    }

    @Override
    public void endVector(List v, String tag) throws IOException {
    }

    @Override
    public void startMap(TreeMap v, String tag) throws IOException {
        this.writeInt(v.size(), tag);
    }

    @Override
    public void endMap(TreeMap v, String tag) throws IOException {
    }
}

