/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CsvRowDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = 2135553495874539201L;
    private final TypeInformation<Row> typeInfo;
    private final RuntimeConverter runtimeConverter;
    private final CsvSchema csvSchema;
    private final ObjectReader objectReader;
    private final boolean ignoreParseErrors;

    private CsvRowDeserializationSchema(RowTypeInfo typeInfo, CsvSchema csvSchema, boolean ignoreParseErrors) {
        this.typeInfo = typeInfo;
        this.runtimeConverter = CsvRowDeserializationSchema.createRowRuntimeConverter(typeInfo, ignoreParseErrors, true);
        this.csvSchema = csvSchema;
        this.objectReader = new CsvMapper().readerFor(JsonNode.class).with((FormatSchema)csvSchema);
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = (JsonNode)this.objectReader.readValue(message);
            return (Row)this.runtimeConverter.convert(root);
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException("Failed to deserialize CSV row '" + new String(message) + "'.", t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CsvRowDeserializationSchema that = (CsvRowDeserializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.typeInfo.equals(that.typeInfo) && this.ignoreParseErrors == that.ignoreParseErrors && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && this.csvSchema.allowsComments() == otherSchema.allowsComments() && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.typeInfo, this.ignoreParseErrors, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.allowsComments(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    private static RuntimeConverter createRowRuntimeConverter(RowTypeInfo rowTypeInfo, boolean ignoreParseErrors, boolean isTopLevel) {
        TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        RuntimeConverter[] fieldConverters = CsvRowDeserializationSchema.createFieldRuntimeConverters(ignoreParseErrors, fieldTypes);
        return CsvRowDeserializationSchema.assembleRowRuntimeConverter(ignoreParseErrors, isTopLevel, fieldNames, fieldConverters);
    }

    private static RuntimeConverter[] createFieldRuntimeConverters(boolean ignoreParseErrors, TypeInformation<?>[] fieldTypes) {
        RuntimeConverter[] fieldConverters = new RuntimeConverter[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldConverters[i] = CsvRowDeserializationSchema.createNullableRuntimeConverter(fieldTypes[i], ignoreParseErrors);
        }
        return fieldConverters;
    }

    private static RuntimeConverter assembleRowRuntimeConverter(boolean ignoreParseErrors, boolean isTopLevel, String[] fieldNames, RuntimeConverter[] fieldConverters) {
        int rowArity = fieldNames.length;
        return node -> {
            int nodeSize = node.size();
            CsvRowDeserializationSchema.validateArity(rowArity, nodeSize, ignoreParseErrors);
            Row row = new Row(rowArity);
            for (int i = 0; i < Math.min(rowArity, nodeSize); ++i) {
                if (isTopLevel) {
                    row.setField(i, fieldConverters[i].convert(node.get(fieldNames[i])));
                    continue;
                }
                row.setField(i, fieldConverters[i].convert(node.get(i)));
            }
            return row;
        };
    }

    private static RuntimeConverter createNullableRuntimeConverter(TypeInformation<?> info, boolean ignoreParseErrors) {
        RuntimeConverter valueConverter = CsvRowDeserializationSchema.createRuntimeConverter(info, ignoreParseErrors);
        return node -> {
            if (node.isNull()) {
                return null;
            }
            try {
                return valueConverter.convert(node);
            }
            catch (Throwable t) {
                if (!ignoreParseErrors) {
                    throw t;
                }
                return null;
            }
        };
    }

    private static RuntimeConverter createRuntimeConverter(TypeInformation<?> info, boolean ignoreParseErrors) {
        if (info.equals((Object)Types.VOID)) {
            return node -> null;
        }
        if (info.equals((Object)Types.STRING)) {
            return JsonNode::asText;
        }
        if (info.equals((Object)Types.BOOLEAN)) {
            return node -> Boolean.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.BYTE)) {
            return node -> Byte.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.SHORT)) {
            return node -> Short.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.INT)) {
            return node -> Integer.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.LONG)) {
            return node -> Long.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.FLOAT)) {
            return node -> Float.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.DOUBLE)) {
            return node -> Double.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.BIG_DEC)) {
            return node -> new BigDecimal(node.asText().trim());
        }
        if (info.equals((Object)Types.BIG_INT)) {
            return node -> new BigInteger(node.asText().trim());
        }
        if (info.equals((Object)Types.SQL_DATE)) {
            return node -> Date.valueOf(node.asText());
        }
        if (info.equals((Object)Types.SQL_TIME)) {
            return node -> Time.valueOf(node.asText());
        }
        if (info.equals((Object)Types.SQL_TIMESTAMP)) {
            return node -> Timestamp.valueOf(node.asText());
        }
        if (info.equals((Object)Types.LOCAL_DATE)) {
            return node -> Date.valueOf(node.asText()).toLocalDate();
        }
        if (info.equals((Object)Types.LOCAL_TIME)) {
            return node -> Time.valueOf(node.asText()).toLocalTime();
        }
        if (info.equals((Object)Types.LOCAL_DATE_TIME)) {
            return node -> Timestamp.valueOf(node.asText()).toLocalDateTime();
        }
        if (info instanceof RowTypeInfo) {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)info;
            return CsvRowDeserializationSchema.createRowRuntimeConverter(rowTypeInfo, ignoreParseErrors, false);
        }
        if (info instanceof BasicArrayTypeInfo) {
            return CsvRowDeserializationSchema.createObjectArrayRuntimeConverter(((BasicArrayTypeInfo)info).getComponentInfo(), ignoreParseErrors);
        }
        if (info instanceof ObjectArrayTypeInfo) {
            return CsvRowDeserializationSchema.createObjectArrayRuntimeConverter(((ObjectArrayTypeInfo)info).getComponentInfo(), ignoreParseErrors);
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return CsvRowDeserializationSchema.createByteArrayRuntimeConverter(ignoreParseErrors);
        }
        throw new RuntimeException("Unsupported type information '" + info + "'.");
    }

    private static RuntimeConverter createObjectArrayRuntimeConverter(TypeInformation<?> elementType, boolean ignoreParseErrors) {
        Class elementClass = elementType.getTypeClass();
        RuntimeConverter elementConverter = CsvRowDeserializationSchema.createNullableRuntimeConverter(elementType, ignoreParseErrors);
        return node -> {
            int nodeSize = node.size();
            Object[] array = (Object[])Array.newInstance(elementClass, nodeSize);
            for (int i = 0; i < nodeSize; ++i) {
                array[i] = elementConverter.convert(node.get(i));
            }
            return array;
        };
    }

    private static RuntimeConverter createByteArrayRuntimeConverter(boolean ignoreParseErrors) {
        return node -> {
            try {
                return node.binaryValue();
            }
            catch (IOException e) {
                if (!ignoreParseErrors) {
                    throw new RuntimeException("Unable to deserialize byte array.", e);
                }
                return null;
            }
        };
    }

    private static void validateArity(int expected, int actual, boolean ignoreParseErrors) {
        if (expected != actual && !ignoreParseErrors) {
            throw new RuntimeException("Row length mismatch. " + expected + " fields expected but was " + actual + ".");
        }
    }

    private static interface RuntimeConverter
    extends Serializable {
        public Object convert(JsonNode var1);
    }

    @PublicEvolving
    public static class Builder {
        private final RowTypeInfo typeInfo;
        private CsvSchema csvSchema;
        private boolean ignoreParseErrors;

        public Builder(TypeInformation<Row> typeInfo) {
            Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
            if (!(typeInfo instanceof RowTypeInfo)) {
                throw new IllegalArgumentException("Row type information expected.");
            }
            this.typeInfo = (RowTypeInfo)typeInfo;
            this.csvSchema = CsvRowSchemaConverter.convert((RowTypeInfo)typeInfo);
        }

        public Builder setFieldDelimiter(char delimiter) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(delimiter).build();
            return this;
        }

        public Builder setAllowComments(boolean allowComments) {
            this.csvSchema = this.csvSchema.rebuild().setAllowComments(allowComments).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Array element delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            Preconditions.checkNotNull((Object)nullLiteral, (String)"Null literal must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setNullValue(nullLiteral).build();
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public CsvRowDeserializationSchema build() {
            return new CsvRowDeserializationSchema(this.typeInfo, this.csvSchema, this.ignoreParseErrors);
        }
    }
}

