/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CsvRowSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = 2098447220136965L;
    private final RowTypeInfo typeInfo;
    private final RuntimeConverter runtimeConverter;
    private final CsvMapper csvMapper;
    private final CsvSchema csvSchema;
    private final ObjectWriter objectWriter;
    private transient ObjectNode root;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    private CsvRowSerializationSchema(RowTypeInfo typeInfo, CsvSchema csvSchema) {
        this.typeInfo = typeInfo;
        this.runtimeConverter = CsvRowSerializationSchema.createRowRuntimeConverter(typeInfo, true);
        this.csvMapper = new CsvMapper();
        this.csvSchema = csvSchema;
        this.objectWriter = this.csvMapper.writer((FormatSchema)csvSchema);
    }

    public byte[] serialize(Row row) {
        if (this.root == null) {
            this.root = this.csvMapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.csvMapper, (ContainerNode<?>)this.root, row);
            return this.objectWriter.writeValueAsBytes((Object)this.root);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CsvRowSerializationSchema that = (CsvRowSerializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.typeInfo.equals((Object)that.typeInfo) && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && Arrays.equals(this.csvSchema.getLineSeparator(), otherSchema.getLineSeparator()) && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.typeInfo, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.getLineSeparator(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    private static RuntimeConverter createRowRuntimeConverter(RowTypeInfo rowTypeInfo, boolean isTopLevel) {
        TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        RuntimeConverter[] fieldConverters = CsvRowSerializationSchema.createFieldRuntimeConverters(fieldTypes);
        return CsvRowSerializationSchema.assembleRowRuntimeConverter(isTopLevel, fieldNames, fieldConverters);
    }

    private static RuntimeConverter[] createFieldRuntimeConverters(TypeInformation<?>[] fieldTypes) {
        RuntimeConverter[] fieldConverters = new RuntimeConverter[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldConverters[i] = CsvRowSerializationSchema.createNullableRuntimeConverter(fieldTypes[i]);
        }
        return fieldConverters;
    }

    private static RuntimeConverter assembleRowRuntimeConverter(boolean isTopLevel, String[] fieldNames, RuntimeConverter[] fieldConverters) {
        int rowArity = fieldNames.length;
        if (isTopLevel) {
            return (csvMapper, container, obj) -> {
                Row row = (Row)obj;
                CsvRowSerializationSchema.validateArity(rowArity, row.getArity());
                ObjectNode objectNode = (ObjectNode)container;
                for (int i = 0; i < rowArity; ++i) {
                    objectNode.set(fieldNames[i], fieldConverters[i].convert(csvMapper, container, row.getField(i)));
                }
                return objectNode;
            };
        }
        return (csvMapper, container, obj) -> {
            Row row = (Row)obj;
            CsvRowSerializationSchema.validateArity(rowArity, row.getArity());
            ArrayNode arrayNode = csvMapper.createArrayNode();
            for (int i = 0; i < rowArity; ++i) {
                arrayNode.add(fieldConverters[i].convert(csvMapper, (ContainerNode<?>)arrayNode, row.getField(i)));
            }
            return arrayNode;
        };
    }

    private static RuntimeConverter createNullableRuntimeConverter(TypeInformation<?> info) {
        RuntimeConverter valueConverter = CsvRowSerializationSchema.createRuntimeConverter(info);
        return (csvMapper, container, obj) -> {
            if (obj == null) {
                return container.nullNode();
            }
            return valueConverter.convert(csvMapper, container, obj);
        };
    }

    private static RuntimeConverter createRuntimeConverter(TypeInformation<?> info) {
        if (info.equals((Object)Types.VOID)) {
            return (csvMapper, container, obj) -> container.nullNode();
        }
        if (info.equals((Object)Types.STRING)) {
            return (csvMapper, container, obj) -> container.textNode((String)obj);
        }
        if (info.equals((Object)Types.BOOLEAN)) {
            return (csvMapper, container, obj) -> container.booleanNode(((Boolean)obj).booleanValue());
        }
        if (info.equals((Object)Types.BYTE)) {
            return (csvMapper, container, obj) -> container.numberNode((Byte)obj);
        }
        if (info.equals((Object)Types.SHORT)) {
            return (csvMapper, container, obj) -> container.numberNode((Short)obj);
        }
        if (info.equals((Object)Types.INT)) {
            return (csvMapper, container, obj) -> container.numberNode((Integer)obj);
        }
        if (info.equals((Object)Types.LONG)) {
            return (csvMapper, container, obj) -> container.numberNode((Long)obj);
        }
        if (info.equals((Object)Types.FLOAT)) {
            return (csvMapper, container, obj) -> container.numberNode((Float)obj);
        }
        if (info.equals((Object)Types.DOUBLE)) {
            return (csvMapper, container, obj) -> container.numberNode((Double)obj);
        }
        if (info.equals((Object)Types.BIG_DEC)) {
            return (csvMapper, container, obj) -> container.numberNode((BigDecimal)obj);
        }
        if (info.equals((Object)Types.BIG_INT)) {
            return (csvMapper, container, obj) -> container.numberNode((BigInteger)obj);
        }
        if (info.equals((Object)Types.SQL_DATE)) {
            return (csvMapper, container, obj) -> container.textNode(obj.toString());
        }
        if (info.equals((Object)Types.SQL_TIME)) {
            return (csvMapper, container, obj) -> container.textNode(obj.toString());
        }
        if (info.equals((Object)Types.SQL_TIMESTAMP)) {
            return (csvMapper, container, obj) -> container.textNode(obj.toString());
        }
        if (info.equals((Object)Types.LOCAL_DATE)) {
            return (csvMapper, container, obj) -> container.textNode(obj.toString());
        }
        if (info.equals((Object)Types.LOCAL_TIME)) {
            return (csvMapper, container, obj) -> container.textNode(obj.toString());
        }
        if (info.equals((Object)Types.LOCAL_DATE_TIME)) {
            return (csvMapper, container, obj) -> container.textNode(DATE_TIME_FORMATTER.format((LocalDateTime)obj));
        }
        if (info instanceof RowTypeInfo) {
            return CsvRowSerializationSchema.createRowRuntimeConverter((RowTypeInfo)info, false);
        }
        if (info instanceof BasicArrayTypeInfo) {
            return CsvRowSerializationSchema.createObjectArrayRuntimeConverter(((BasicArrayTypeInfo)info).getComponentInfo());
        }
        if (info instanceof ObjectArrayTypeInfo) {
            return CsvRowSerializationSchema.createObjectArrayRuntimeConverter(((ObjectArrayTypeInfo)info).getComponentInfo());
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return CsvRowSerializationSchema.createByteArrayRuntimeConverter();
        }
        throw new RuntimeException("Unsupported type information '" + info + "'.");
    }

    private static RuntimeConverter createObjectArrayRuntimeConverter(TypeInformation<?> elementType) {
        RuntimeConverter elementConverter = CsvRowSerializationSchema.createNullableRuntimeConverter(elementType);
        return (csvMapper, container, obj) -> {
            Object[] array = (Object[])obj;
            ArrayNode arrayNode = csvMapper.createArrayNode();
            for (Object element : array) {
                arrayNode.add(elementConverter.convert(csvMapper, (ContainerNode<?>)arrayNode, element));
            }
            return arrayNode;
        };
    }

    private static RuntimeConverter createByteArrayRuntimeConverter() {
        return (csvMapper, container, obj) -> container.binaryNode((byte[])obj);
    }

    private static void validateArity(int expected, int actual) {
        if (expected != actual) {
            throw new RuntimeException("Row length mismatch. " + expected + " fields expected but was " + actual + ".");
        }
    }

    private static interface RuntimeConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, Object var3);
    }

    @PublicEvolving
    public static class Builder {
        private final RowTypeInfo typeInfo;
        private CsvSchema csvSchema;

        public Builder(TypeInformation<Row> typeInfo) {
            Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
            if (!(typeInfo instanceof RowTypeInfo)) {
                throw new IllegalArgumentException("Row type information expected.");
            }
            this.typeInfo = (RowTypeInfo)typeInfo;
            this.csvSchema = CsvRowSchemaConverter.convert((RowTypeInfo)typeInfo);
        }

        public Builder setFieldDelimiter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(c).build();
            return this;
        }

        public Builder setLineDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            if (!(delimiter.equals("\n") || delimiter.equals("\r") || delimiter.equals("\r\n") || delimiter.equals(""))) {
                throw new IllegalArgumentException("Unsupported new line delimiter. Only \\n, \\r, \\r\\n, or empty string are supported.");
            }
            this.csvSchema = this.csvSchema.rebuild().setLineSeparator(delimiter).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String s) {
            this.csvSchema = this.csvSchema.rebuild().setNullValue(s).build();
            return this;
        }

        public CsvRowSerializationSchema build() {
            return new CsvRowSerializationSchema(this.typeInfo, this.csvSchema);
        }
    }
}

