/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.io.jdbc.JDBCAppendTableSinkBuilder;
import org.apache.flink.api.java.io.jdbc.JDBCOutputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCSinkFunction;
import org.apache.flink.api.java.io.jdbc.JDBCTypeUtil;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.util.TableConnectorUtil;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class JDBCAppendTableSink
implements AppendStreamTableSink<Row>,
BatchTableSink<Row> {
    private final JDBCOutputFormat outputFormat;
    private String[] fieldNames;
    private TypeInformation[] fieldTypes;

    JDBCAppendTableSink(JDBCOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public static JDBCAppendTableSinkBuilder builder() {
        return new JDBCAppendTableSinkBuilder();
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        dataStream.addSink((SinkFunction)new JDBCSinkFunction(this.outputFormat)).name(TableConnectorUtil.generateRuntimeName(this.getClass(), (String[])this.fieldNames));
    }

    public void emitDataSet(DataSet<Row> dataSet) {
        dataSet.output((OutputFormat)this.outputFormat);
    }

    public TypeInformation<Row> getOutputType() {
        return new RowTypeInfo(this.fieldTypes, this.fieldNames);
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        JDBCAppendTableSink copy;
        int[] types = this.outputFormat.getTypesArray();
        String sinkSchema = String.join((CharSequence)", ", IntStream.of(types).mapToObj(JDBCTypeUtil::getTypeName).collect(Collectors.toList()));
        String tableSchema = String.join((CharSequence)", ", Stream.of(fieldTypes).map(JDBCTypeUtil::getTypeName).collect(Collectors.toList()));
        String msg = String.format("Schema of output table is incompatible with JDBCAppendTableSink schema. Table schema: [%s], sink schema: [%s]", tableSchema, sinkSchema);
        Preconditions.checkArgument((fieldTypes.length == types.length ? 1 : 0) != 0, (Object)msg);
        for (int i = 0; i < types.length; ++i) {
            Preconditions.checkArgument((JDBCTypeUtil.typeInformationToSqlType(fieldTypes[i]) == types[i] ? 1 : 0) != 0, (Object)msg);
        }
        try {
            copy = new JDBCAppendTableSink((JDBCOutputFormat)((Object)InstantiationUtil.clone((Serializable)((Object)this.outputFormat))));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        copy.fieldNames = fieldNames;
        copy.fieldTypes = fieldTypes;
        return copy;
    }

    @VisibleForTesting
    JDBCOutputFormat getOutputFormat() {
        return this.outputFormat;
    }
}

