/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.split;

import java.io.Serializable;
import org.apache.flink.api.java.io.jdbc.split.ParameterValuesProvider;
import org.apache.flink.util.Preconditions;

public class NumericBetweenParametersProvider
implements ParameterValuesProvider {
    private final long fetchSize;
    private final long minVal;
    private final long maxVal;

    public NumericBetweenParametersProvider(long fetchSize, long minVal, long maxVal) {
        Preconditions.checkArgument((fetchSize > 0L ? 1 : 0) != 0, (Object)"Fetch size must be greater than 0.");
        Preconditions.checkArgument((minVal <= maxVal ? 1 : 0) != 0, (Object)"Min value cannot be greater than max value.");
        this.fetchSize = fetchSize;
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    @Override
    public Serializable[][] getParameterValues() {
        double maxElemCount = this.maxVal - this.minVal + 1L;
        int numBatches = new Double(Math.ceil(maxElemCount / (double)this.fetchSize)).intValue();
        Serializable[][] parameters = new Serializable[numBatches][2];
        int batchIndex = 0;
        long start = this.minVal;
        while (start <= this.maxVal) {
            long end = start + this.fetchSize - 1L;
            if (end > this.maxVal) {
                end = this.maxVal;
            }
            parameters[batchIndex] = new Long[]{start, end};
            start += this.fetchSize;
            ++batchIndex;
        }
        return parameters;
    }
}

