/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.AbstractContainerizedClusterClientFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.kubeclient.KubeClientFactory;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

@Internal
public class KubernetesClusterClientFactory
extends AbstractContainerizedClusterClientFactory<String> {
    private static final String CLUSTER_ID_PREFIX = "flink-cluster-";

    public boolean isCompatibleWith(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String deploymentTarget = configuration.getString(DeploymentOptions.TARGET);
        return KubernetesDeploymentTarget.isValidKubernetesTarget(deploymentTarget);
    }

    public KubernetesClusterDescriptor createClusterDescriptor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        if (!configuration.contains(KubernetesConfigOptions.CLUSTER_ID)) {
            String clusterId = this.generateClusterId();
            configuration.setString(KubernetesConfigOptions.CLUSTER_ID, clusterId);
        }
        return new KubernetesClusterDescriptor(configuration, KubeClientFactory.fromConfiguration(configuration));
    }

    @Nullable
    public String getClusterId(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.getString(KubernetesConfigOptions.CLUSTER_ID);
    }

    private String generateClusterId() {
        String randomID = new AbstractID().toString();
        return (CLUSTER_ID_PREFIX + randomID).substring(0, 45);
    }
}

