/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.GenericCLI;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.kubernetes.executors.KubernetesSessionClusterExecutor;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.KubeClientFactory;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KubernetesSessionCli {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSessionCli.class);
    private static final long CLIENT_POLLING_INTERVAL_MS = 3000L;
    private static final String KUBERNETES_CLUSTER_HELP = "Available commands:\nhelp - show these commands\nstop - stop the kubernetes cluster\nquit - quit attach mode";
    private final Configuration baseConfiguration;
    private final GenericCLI cli;
    private final ClusterClientServiceLoader clusterClientServiceLoader;

    public KubernetesSessionCli(Configuration configuration, String configDir) {
        this(configuration, (ClusterClientServiceLoader)new DefaultClusterClientServiceLoader(), configDir);
    }

    public KubernetesSessionCli(Configuration configuration, ClusterClientServiceLoader clusterClientServiceLoader, String configDir) {
        this.baseConfiguration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.clusterClientServiceLoader = (ClusterClientServiceLoader)Preconditions.checkNotNull((Object)clusterClientServiceLoader);
        this.cli = new GenericCLI(this.baseConfiguration, configDir);
    }

    public Configuration getEffectiveConfiguration(String[] args) throws CliArgsException {
        CommandLine commandLine = this.cli.parseCommandLineOptions(args, true);
        Configuration effectiveConfiguration = this.cli.applyCommandLineOptionsToConfiguration(commandLine);
        effectiveConfiguration.set(DeploymentOptions.TARGET, (Object)KubernetesSessionClusterExecutor.NAME);
        return effectiveConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) throws FlinkException, CliArgsException {
        Configuration configuration = this.getEffectiveConfiguration(args);
        ClusterClientFactory kubernetesClusterClientFactory = this.clusterClientServiceLoader.getClusterClientFactory(configuration);
        ClusterDescriptor kubernetesClusterDescriptor = kubernetesClusterClientFactory.createClusterDescriptor(configuration);
        try {
            ClusterClient clusterClient;
            String clusterId = (String)kubernetesClusterClientFactory.getClusterId(configuration);
            boolean detached = (Boolean)configuration.get(DeploymentOptions.ATTACHED) == false;
            FlinkKubeClient kubeClient = KubeClientFactory.fromConfiguration(configuration);
            if (clusterId != null && kubeClient.getRestService(clusterId).isPresent()) {
                clusterClient = kubernetesClusterDescriptor.retrieve((Object)clusterId).getClusterClient();
            } else {
                clusterClient = kubernetesClusterDescriptor.deploySessionCluster(kubernetesClusterClientFactory.getClusterSpecification(configuration)).getClusterClient();
                clusterId = (String)clusterClient.getClusterId();
            }
            try {
                if (!detached) {
                    Tuple2<Boolean, Boolean> continueRepl = new Tuple2<Boolean, Boolean>((Object)true, (Object)false);
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in));){
                        while (((Boolean)continueRepl.f0).booleanValue()) {
                            continueRepl = this.repStep(in);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Exception while running the interactive command line interface.", (Throwable)e);
                    }
                    if (((Boolean)continueRepl.f1).booleanValue()) {
                        kubernetesClusterDescriptor.killCluster((Object)clusterId);
                    }
                }
                clusterClient.close();
                kubeClient.close();
            }
            catch (Exception e) {
                LOG.info("Could not properly shutdown cluster client.", (Throwable)e);
            }
        }
        finally {
            try {
                kubernetesClusterDescriptor.close();
            }
            catch (Exception e) {
                LOG.info("Could not properly close the kubernetes cluster descriptor.", (Throwable)e);
            }
        }
        return 0;
    }

    private Tuple2<Boolean, Boolean> repStep(BufferedReader in) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 3000L && !in.ready()) {
            Thread.sleep(200L);
        }
        if (in.ready()) {
            String command;
            switch (command = in.readLine()) {
                case "quit": {
                    return new Tuple2((Object)false, (Object)false);
                }
                case "stop": {
                    return new Tuple2((Object)false, (Object)true);
                }
                case "help": {
                    System.err.println(KUBERNETES_CLUSTER_HELP);
                    break;
                }
                default: {
                    System.err.println("Unknown command '" + command + "'. Showing help:");
                    System.err.println(KUBERNETES_CLUSTER_HELP);
                }
            }
        }
        return new Tuple2((Object)true, (Object)false);
    }

    public static void main(String[] args) {
        int retCode;
        Configuration configuration = GlobalConfiguration.loadConfiguration();
        String configDir = CliFrontend.getConfigurationDirectoryFromEnv();
        try {
            KubernetesSessionCli cli = new KubernetesSessionCli(configuration, configDir);
            retCode = (Integer)SecurityUtils.getInstalledContext().runSecured(() -> cli.run(args));
        }
        catch (CliArgsException e) {
            retCode = AbstractCustomCommandLine.handleCliArgsException((CliArgsException)e, (Logger)LOG);
        }
        catch (Exception e) {
            retCode = AbstractCustomCommandLine.handleError((Throwable)e, (Logger)LOG);
        }
        System.exit(retCode);
    }
}

