/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.configuration;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.runtime.util.EnvironmentInformation;

@PublicEvolving
public class KubernetesConfigOptions {
    public static final ConfigOption<String> CONTEXT = ConfigOptions.key((String)"kubernetes.context").stringType().noDefaultValue().withDescription("The desired context from your Kubernetes config file used to configure the Kubernetes client for interacting with the cluster. This could be helpful if one has multiple contexts configured and wants to administrate different Flink clusters on different Kubernetes clusters/contexts.");
    public static final ConfigOption<ServiceExposedType> REST_SERVICE_EXPOSED_TYPE = ConfigOptions.key((String)"kubernetes.rest-service.exposed.type").enumType(ServiceExposedType.class).defaultValue((Object)ServiceExposedType.LoadBalancer).withDescription("The exposed type of the rest service (ClusterIP or NodePort or LoadBalancer). The exposed rest service could be used to access the Flink\u2019s Web UI and REST endpoint.");
    public static final ConfigOption<String> JOB_MANAGER_SERVICE_ACCOUNT = ConfigOptions.key((String)"kubernetes.jobmanager.service-account").stringType().defaultValue((Object)"default").withDescription("Service account that is used by jobmanager within kubernetes cluster. The job manager uses this service account when requesting taskmanager pods from the API server.");
    public static final ConfigOption<Double> JOB_MANAGER_CPU = ConfigOptions.key((String)"kubernetes.jobmanager.cpu").doubleType().defaultValue((Object)1.0).withDescription("The number of cpu used by job manager");
    public static final ConfigOption<Double> TASK_MANAGER_CPU = ConfigOptions.key((String)"kubernetes.taskmanager.cpu").doubleType().defaultValue((Object)-1.0).withDescription("The number of cpu used by task manager. By default, the cpu is set to the number of slots per TaskManager");
    public static final ConfigOption<ImagePullPolicy> CONTAINER_IMAGE_PULL_POLICY = ConfigOptions.key((String)"kubernetes.container.image.pull-policy").enumType(ImagePullPolicy.class).defaultValue((Object)ImagePullPolicy.IfNotPresent).withDescription("The Kubernetes container image pull policy (IfNotPresent or Always or Never). The default policy is IfNotPresent to avoid putting pressure to image repository.");
    public static final ConfigOption<List<String>> CONTAINER_IMAGE_PULL_SECRETS = ConfigOptions.key((String)"kubernetes.container.image.pull-secrets").stringType().asList().noDefaultValue().withDescription("A semicolon-separated list of the Kubernetes secrets used to access private image registries.");
    public static final ConfigOption<String> KUBE_CONFIG_FILE = ConfigOptions.key((String)"kubernetes.config.file").stringType().noDefaultValue().withDescription("The kubernetes config file will be used to create the client. The default is located at ~/.kube/config");
    public static final ConfigOption<String> NAMESPACE = ConfigOptions.key((String)"kubernetes.namespace").stringType().defaultValue((Object)"default").withDescription("The namespace that will be used for running the jobmanager and taskmanager pods.");
    public static final ConfigOption<String> CONTAINER_START_COMMAND_TEMPLATE = ConfigOptions.key((String)"kubernetes.container-start-command-template").stringType().defaultValue((Object)"%java% %classpath% %jvmmem% %jvmopts% %logging% %class% %args% %redirects%").withDescription("Template for the kubernetes jobmanager and taskmanager container start invocation.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_LABELS = ConfigOptions.key((String)"kubernetes.jobmanager.labels").mapType().noDefaultValue().withDescription("The labels to be set for JobManager pod. Specified as key:value pairs separated by commas. For example, version:alphav1,deploy:test.");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_LABELS = ConfigOptions.key((String)"kubernetes.taskmanager.labels").mapType().noDefaultValue().withDescription("The labels to be set for TaskManager pods. Specified as key:value pairs separated by commas. For example, version:alphav1,deploy:test.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_NODE_SELECTOR = ConfigOptions.key((String)"kubernetes.jobmanager.node-selector").mapType().noDefaultValue().withDescription("The node selector to be set for JobManager pod. Specified as key:value pairs separated by commas. For example, environment:production,disk:ssd.");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_NODE_SELECTOR = ConfigOptions.key((String)"kubernetes.taskmanager.node-selector").mapType().noDefaultValue().withDescription("The node selector to be set for TaskManager pods. Specified as key:value pairs separated by commas. For example, environment:production,disk:ssd.");
    public static final ConfigOption<String> CLUSTER_ID = ConfigOptions.key((String)"kubernetes.cluster-id").stringType().noDefaultValue().withDescription("The cluster-id, which should be no more than 45 characters, is used for identifying a unique Flink cluster. If not set, the client will automatically generate it with a random ID.");
    @Documentation.OverrideDefault(value="The default value depends on the actually running version. In general it looks like \"flink:<FLINK_VERSION>-scala_<SCALA_VERSION>\"")
    public static final ConfigOption<String> CONTAINER_IMAGE = ConfigOptions.key((String)"kubernetes.container.image").stringType().defaultValue((Object)KubernetesConfigOptions.getDefaultFlinkImage()).withDescription("Image to use for Flink containers. The specified image must be based upon the same Apache Flink and Scala versions as used by the application. Visit https://hub.docker.com/_/flink?tab=tags for the images provided by the Flink project.");
    public static final ConfigOption<String> KUBERNETES_ENTRY_PATH = ConfigOptions.key((String)"kubernetes.entry.path").stringType().defaultValue((Object)"/opt/flink/bin/kubernetes-entry.sh").withDescription("The entrypoint script of kubernetes in the image. It will be used as command for jobmanager and taskmanager container.");
    public static final ConfigOption<String> FLINK_CONF_DIR = ConfigOptions.key((String)"kubernetes.flink.conf.dir").stringType().defaultValue((Object)"/opt/flink/conf").withDescription("The flink conf directory that will be mounted in pod. The flink-conf.yaml, log4j.properties, logback.xml in this path will be overwritten from config map.");
    public static final ConfigOption<String> FLINK_LOG_DIR = ConfigOptions.key((String)"kubernetes.flink.log.dir").stringType().defaultValue((Object)"/opt/flink/log").withDescription("The directory that logs of jobmanager and taskmanager be saved in the pod.");
    public static final ConfigOption<String> HADOOP_CONF_CONFIG_MAP = ConfigOptions.key((String)"kubernetes.hadoop.conf.config-map.name").stringType().noDefaultValue().withDescription("Specify the name of an existing ConfigMap that contains custom Hadoop configuration to be mounted on the JobManager(s) and TaskManagers.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.jobmanager.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the JobManager pod. The value could be in the form of a1:v1,a2:v2");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.taskmanager.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the TaskManager pod. The value could be in the form of a1:v1,a2:v2");
    public static final ConfigOption<List<Map<String, String>>> JOB_MANAGER_TOLERATIONS = ConfigOptions.key((String)"kubernetes.jobmanager.tolerations").mapType().asList().noDefaultValue().withDescription("The user-specified tolerations to be set to the JobManager pod. The value should be in the form of key:key1,operator:Equal,value:value1,effect:NoSchedule;key:key2,operator:Exists,effect:NoExecute,tolerationSeconds:6000");
    public static final ConfigOption<List<Map<String, String>>> TASK_MANAGER_TOLERATIONS = ConfigOptions.key((String)"kubernetes.taskmanager.tolerations").mapType().asList().noDefaultValue().withDescription("The user-specified tolerations to be set to the TaskManager pod. The value should be in the form of key:key1,operator:Equal,value:value1,effect:NoSchedule;key:key2,operator:Exists,effect:NoExecute,tolerationSeconds:6000");
    public static final ConfigOption<Map<String, String>> REST_SERVICE_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.rest-service.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the rest Service. The value should be in the form of a1:v1,a2:v2");
    public static final String EXTERNAL_RESOURCE_KUBERNETES_CONFIG_KEY_SUFFIX = "kubernetes.config-key";
    public static final ConfigOption<String> EXTERNAL_RESOURCE_KUBERNETES_CONFIG_KEY = ConfigOptions.key((String)ExternalResourceOptions.genericKeyWithSuffix((String)"kubernetes.config-key")).stringType().noDefaultValue().withDescription("If configured, Flink will add \"resources.limits.<config-key>\" and \"resources.requests.<config-key>\" to the main container of TaskExecutor and set the value to the value of " + ExternalResourceOptions.EXTERNAL_RESOURCE_AMOUNT.key() + ".");

    private static String getDefaultFlinkImage() {
        boolean snapshot = EnvironmentInformation.getVersion().toLowerCase(Locale.ENGLISH).contains("snapshot");
        String tag = snapshot ? "latest" : EnvironmentInformation.getVersion() + "-scala_" + EnvironmentInformation.getScalaVersion();
        return "flink:" + tag;
    }

    private KubernetesConfigOptions() {
    }

    public static enum ImagePullPolicy {
        IfNotPresent,
        Always,
        Never;

    }

    public static enum ServiceExposedType {
        ClusterIP,
        NodePort,
        LoadBalancer;

    }
}

