/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.application.ApplicationClusterEntryPoint;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.deployment.application.ClassPathPackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.entrypoint.KubernetesEntrypointUtils;
import org.apache.flink.kubernetes.entrypoint.KubernetesResourceManagerFactory;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.util.ClusterEntrypointUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

@Internal
public final class KubernetesApplicationClusterEntrypoint
extends ApplicationClusterEntryPoint {
    private KubernetesApplicationClusterEntrypoint(Configuration configuration, PackagedProgram program) {
        super(configuration, program, (ResourceManagerFactory)KubernetesResourceManagerFactory.getInstance());
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)KubernetesApplicationClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration configuration = KubernetesEntrypointUtils.loadConfiguration();
        PackagedProgram program = null;
        try {
            program = KubernetesApplicationClusterEntrypoint.getPackagedProgram(configuration);
        }
        catch (Exception e) {
            LOG.error("Could not create application program.", (Throwable)e);
            System.exit(1);
        }
        try {
            KubernetesApplicationClusterEntrypoint.configureExecution((Configuration)configuration, (PackagedProgram)program);
        }
        catch (Exception e) {
            LOG.error("Could not apply application configuration.", (Throwable)e);
            System.exit(1);
        }
        KubernetesApplicationClusterEntrypoint kubernetesApplicationClusterEntrypoint = new KubernetesApplicationClusterEntrypoint(configuration, program);
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)kubernetesApplicationClusterEntrypoint);
    }

    private static PackagedProgram getPackagedProgram(Configuration configuration) throws IOException, FlinkException {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.fromConfiguration((Configuration)configuration);
        PackagedProgramRetriever programRetriever = KubernetesApplicationClusterEntrypoint.getPackagedProgramRetriever(configuration, applicationConfiguration.getProgramArguments(), applicationConfiguration.getApplicationClassName());
        return programRetriever.getPackagedProgram();
    }

    private static PackagedProgramRetriever getPackagedProgramRetriever(Configuration configuration, String[] programArguments, @Nullable String jobClassName) throws IOException {
        List<File> pipelineJars = KubernetesUtils.checkJarFileForApplicationMode(configuration);
        Preconditions.checkArgument((pipelineJars.size() == 1 ? 1 : 0) != 0, (Object)"Should only have one jar");
        File userLibDir = ClusterEntrypointUtils.tryFindUserLibDirectory().orElse(null);
        ClassPathPackagedProgramRetriever.Builder retrieverBuilder = ClassPathPackagedProgramRetriever.newBuilder((String[])programArguments).setUserLibDirectory(userLibDir).setJarFile(pipelineJars.get(0)).setJobClassName(jobClassName);
        return retrieverBuilder.build();
    }
}

