/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.KubernetesResourceManager;
import org.apache.flink.kubernetes.KubernetesWorkerNode;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesResourceManagerConfiguration;
import org.apache.flink.kubernetes.entrypoint.KubernetesWorkerResourceSpecFactory;
import org.apache.flink.kubernetes.kubeclient.KubeClientFactory;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerImpl;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ActiveResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ConfigurationException;

public class KubernetesResourceManagerFactory
extends ActiveResourceManagerFactory<KubernetesWorkerNode> {
    private static final KubernetesResourceManagerFactory INSTANCE = new KubernetesResourceManagerFactory();
    private static final Time POD_CREATION_RETRY_INTERVAL = Time.seconds((long)3L);

    private KubernetesResourceManagerFactory() {
    }

    public static KubernetesResourceManagerFactory getInstance() {
        return INSTANCE;
    }

    public ResourceManager<KubernetesWorkerNode> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, ResourceManagerMetricGroup resourceManagerMetricGroup, ResourceManagerRuntimeServices resourceManagerRuntimeServices) {
        KubernetesResourceManagerConfiguration kubernetesResourceManagerConfiguration = new KubernetesResourceManagerConfiguration(configuration.getString(KubernetesConfigOptions.CLUSTER_ID), POD_CREATION_RETRY_INTERVAL);
        return new KubernetesResourceManager(rpcService, resourceId, configuration, highAvailabilityServices, heartbeatServices, resourceManagerRuntimeServices.getSlotManager(), ResourceManagerPartitionTrackerImpl::new, resourceManagerRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, KubeClientFactory.fromConfiguration(configuration), kubernetesResourceManagerConfiguration);
    }

    protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
        return ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpecFactory)KubernetesWorkerResourceSpecFactory.INSTANCE);
    }
}

