/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesService;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesWatch;

public interface FlinkKubeClient
extends AutoCloseable {
    public void createJobManagerComponent(KubernetesJobManagerSpecification var1);

    public CompletableFuture<Void> createTaskManagerPod(KubernetesPod var1);

    public CompletableFuture<Void> stopPod(String var1);

    public void stopAndCleanupCluster(String var1);

    public Optional<KubernetesService> getRestService(String var1);

    public Optional<Endpoint> getRestEndpoint(String var1);

    public List<KubernetesPod> getPodsWithLabels(Map<String, String> var1);

    public void handleException(Exception var1);

    public KubernetesWatch watchPodsAndDoCallback(Map<String, String> var1, PodCallbackHandler var2);

    public static interface PodCallbackHandler {
        public void onAdded(List<KubernetesPod> var1);

        public void onModified(List<KubernetesPod> var1);

        public void onDeleted(List<KubernetesPod> var1);

        public void onError(List<KubernetesPod> var1);

        public void handleFatalError(Throwable var1);
    }
}

