/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Fabric8FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KubeClientFactory.class);

    public static FlinkKubeClient fromConfiguration(Configuration flinkConfig) {
        Config config;
        String kubeConfigFile;
        String kubeContext = flinkConfig.getString(KubernetesConfigOptions.CONTEXT);
        if (kubeContext != null) {
            LOG.info("Configuring kubernetes client to use context {}.", (Object)kubeContext);
        }
        if ((kubeConfigFile = flinkConfig.getString(KubernetesConfigOptions.KUBE_CONFIG_FILE)) != null) {
            LOG.debug("Trying to load kubernetes config from file: {}.", (Object)kubeConfigFile);
            try {
                config = Config.fromKubeconfig(kubeContext, FileUtils.readFileUtf8((File)new File(kubeConfigFile)), null);
            }
            catch (IOException e) {
                throw new KubernetesClientException("Load kubernetes config failed.", e);
            }
        } else {
            LOG.debug("Trying to load default kubernetes config.");
            config = Config.autoConfigure(kubeContext);
        }
        DefaultKubernetesClient client = new DefaultKubernetesClient(config);
        return new Fabric8FlinkKubeClient(flinkConfig, client, KubeClientFactory::createThreadPoolForAsyncIO);
    }

    private static ExecutorService createThreadPoolForAsyncIO() {
        return Executors.newFixedThreadPool(2, (ThreadFactory)new ExecutorThreadFactory("FlinkKubeClient-IO"));
    }
}

