/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.shaded.guava18.com.google.common.io.Files;
import org.apache.flink.util.Preconditions;

public class FlinkConfMountDecorator
extends AbstractKubernetesStepDecorator {
    private final AbstractKubernetesParameters kubernetesComponentConf;

    public FlinkConfMountDecorator(AbstractKubernetesParameters kubernetesComponentConf) {
        this.kubernetesComponentConf = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesComponentConf);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Pod mountedPod = this.decoratePod(flinkPod.getPod());
        Container mountedMainContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(flinkPod.getMainContainer()).addNewVolumeMount().withName("flink-config-volume")).withMountPath(this.kubernetesComponentConf.getFlinkConfDirInPod())).endVolumeMount()).build();
        return new FlinkPod.Builder(flinkPod).withPod(mountedPod).withMainContainer(mountedMainContainer).build();
    }

    private Pod decoratePod(Pod pod) {
        List<KeyToPath> keyToPaths = this.getLocalLogConfFiles().stream().map(file -> ((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(file.getName())).withPath(file.getName())).build()).collect(Collectors.toList());
        keyToPaths.add(((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey("flink-conf.yaml")).withPath("flink-conf.yaml")).build());
        Volume flinkConfVolume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName("flink-config-volume")).withNewConfigMap().withName(FlinkConfMountDecorator.getFlinkConfConfigMapName(this.kubernetesComponentConf.getClusterId()))).withItems(keyToPaths)).endConfigMap()).build();
        return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().addNewVolumeLike(flinkConfVolume).endVolume()).endSpec()).build();
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        String clusterId = this.kubernetesComponentConf.getClusterId();
        HashMap<String, String> data = new HashMap<String, String>();
        List<File> localLogFiles = this.getLocalLogConfFiles();
        for (File file : localLogFiles) {
            data.put(file.getName(), Files.toString((File)file, (Charset)StandardCharsets.UTF_8));
        }
        Map<String, String> propertiesMap = this.getClusterSidePropertiesMap(this.kubernetesComponentConf.getFlinkConfiguration());
        data.put("flink-conf.yaml", this.getFlinkConfData(propertiesMap));
        ConfigMap flinkConfConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withApiVersion("v1")).withNewMetadata().withName(FlinkConfMountDecorator.getFlinkConfConfigMapName(clusterId))).withLabels(this.kubernetesComponentConf.getCommonLabels())).endMetadata()).addToData(data)).build();
        return Collections.singletonList(flinkConfConfigMap);
    }

    private Map<String, String> getClusterSidePropertiesMap(Configuration flinkConfig) {
        Configuration clusterSideConfig = flinkConfig.clone();
        clusterSideConfig.removeConfig(KubernetesConfigOptions.KUBE_CONFIG_FILE);
        clusterSideConfig.removeConfig(DeploymentOptionsInternal.CONF_DIR);
        return clusterSideConfig.toMap();
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    String getFlinkConfData(Map<String, String> propertiesMap) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<File> getLocalLogConfFiles() {
        String confDir = this.kubernetesComponentConf.getConfigDirectory();
        File logbackFile = new File(confDir, "logback.xml");
        File log4jFile = new File(confDir, "log4j.properties");
        ArrayList<File> localLogConfFiles = new ArrayList<File>();
        if (logbackFile.exists()) {
            localLogConfFiles.add(logbackFile);
        }
        if (log4jFile.exists()) {
            localLogConfFiles.add(log4jFile);
        }
        return localLogConfFiles;
    }

    @VisibleForTesting
    public static String getFlinkConfConfigMapName(String clusterId) {
        return "flink-config-" + clusterId;
    }

    private static /* synthetic */ void lambda$getFlinkConfData$1(PrintWriter out, String k, String v) {
        out.print(k);
        out.print(": ");
        out.println(v);
    }
}

