/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesToleration;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class InitTaskManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesTaskManagerParameters kubernetesTaskManagerParameters;

    public InitTaskManagerDecorator(KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        this.kubernetesTaskManagerParameters = (KubernetesTaskManagerParameters)Preconditions.checkNotNull((Object)kubernetesTaskManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Pod basicPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodBuilder)new PodBuilder(flinkPod.getPod()).withApiVersion("v1")).editOrNewMetadata().withName(this.kubernetesTaskManagerParameters.getPodName())).withLabels(this.kubernetesTaskManagerParameters.getLabels())).withAnnotations(this.kubernetesTaskManagerParameters.getAnnotations())).endMetadata()).editOrNewSpec().withRestartPolicy("Never")).withImagePullSecrets(this.kubernetesTaskManagerParameters.getImagePullSecrets())).withNodeSelector(this.kubernetesTaskManagerParameters.getNodeSelector())).withTolerations(this.kubernetesTaskManagerParameters.getTolerations().stream().map(e -> (Toleration)KubernetesToleration.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endSpec()).build();
        Container basicMainContainer = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(basicPod).withMainContainer(basicMainContainer).build();
    }

    private Container decorateMainContainer(Container container) {
        ResourceRequirements resourceRequirements = KubernetesUtils.getResourceRequirements(this.kubernetesTaskManagerParameters.getTaskManagerMemoryMB(), this.kubernetesTaskManagerParameters.getTaskManagerCPU(), this.kubernetesTaskManagerParameters.getTaskManagerExternalResources());
        return ((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(container).withName(this.kubernetesTaskManagerParameters.getTaskManagerMainContainerName())).withImage(this.kubernetesTaskManagerParameters.getImage())).withImagePullPolicy(this.kubernetesTaskManagerParameters.getImagePullPolicy().name())).withResources(resourceRequirements)).withPorts(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("taskmanager-rpc")).withContainerPort(this.kubernetesTaskManagerParameters.getRPCPort())).build())).withEnv(this.getCustomizedEnvs())).addNewEnv().withName("_FLINK_POD_NAME")).withValue(this.kubernetesTaskManagerParameters.getPodName())).endEnv()).build();
    }

    private List<EnvVar> getCustomizedEnvs() {
        return this.kubernetesTaskManagerParameters.getEnvironments().entrySet().stream().map(kv -> new EnvVar((String)kv.getKey(), (String)kv.getValue(), null)).collect(Collectors.toList());
    }
}

