/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Collections;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsWatcher
implements Watcher<Pod> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsWatcher.class);
    private final FlinkKubeClient.PodCallbackHandler podsCallbackHandler;

    public KubernetesPodsWatcher(FlinkKubeClient.PodCallbackHandler callbackHandler) {
        this.podsCallbackHandler = callbackHandler;
    }

    @Override
    public void eventReceived(Watcher.Action action, Pod pod) {
        LOG.debug("Received {} event for pod {}, details: {}", new Object[]{action, pod.getMetadata().getName(), pod.getStatus()});
        switch (action) {
            case ADDED: {
                this.podsCallbackHandler.onAdded(Collections.singletonList(new KubernetesPod(pod)));
                break;
            }
            case MODIFIED: {
                this.podsCallbackHandler.onModified(Collections.singletonList(new KubernetesPod(pod)));
                break;
            }
            case ERROR: {
                this.podsCallbackHandler.onError(Collections.singletonList(new KubernetesPod(pod)));
                break;
            }
            case DELETED: {
                this.podsCallbackHandler.onDeleted(Collections.singletonList(new KubernetesPod(pod)));
                break;
            }
            default: {
                LOG.debug("Ignore handling {} event for pod {}", (Object)action, (Object)pod.getMetadata().getName());
            }
        }
    }

    @Override
    public void onClose(KubernetesClientException cause) {
        if (cause == null) {
            LOG.info("The pods watcher is closing.");
        } else {
            this.podsCallbackHandler.handleFatalError(cause);
        }
    }
}

