/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.taskmanager;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesTaskExecutorRunner {
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesTaskExecutorRunner.class);

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"Kubernetes TaskExecutor runner", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        String resourceID = System.getenv().get("_FLINK_POD_NAME");
        Preconditions.checkArgument((resourceID != null ? 1 : 0) != 0, (String)"Pod name variable %s not set", (Object[])new Object[]{"_FLINK_POD_NAME"});
        TaskManagerRunner.runTaskManagerProcessSecurely((String[])args, (ResourceID)new ResourceID(resourceID));
    }
}

