/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.utils;

import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesUtils.class);

    public static void checkAndUpdatePortConfigOption(Configuration flinkConfig, ConfigOption<String> port, int fallbackPort) {
        if (KubernetesUtils.parsePort(flinkConfig, port) == 0) {
            flinkConfig.setString(port, String.valueOf(fallbackPort));
            LOG.info("Kubernetes deployment requires a fixed port. Configuration {} will be set to {}", (Object)port.key(), (Object)fallbackPort);
        }
    }

    public static Integer parsePort(Configuration flinkConfig, ConfigOption<String> port) {
        Preconditions.checkNotNull((Object)flinkConfig.get(port), (String)(port.key() + " should not be null."));
        try {
            return Integer.parseInt((String)flinkConfig.get(port));
        }
        catch (NumberFormatException ex) {
            throw new FlinkRuntimeException(port.key() + " should be specified to a fixed port. Do not support a range of ports.", (Throwable)ex);
        }
    }

    public static String getDeploymentName(String clusterId) {
        return clusterId;
    }

    public static Map<String, String> getTaskManagerLabels(String clusterId) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("type", "flink-native-kubernetes");
        labels.put("app", clusterId);
        labels.put("component", "taskmanager");
        return Collections.unmodifiableMap(labels);
    }

    public static ResourceRequirements getResourceRequirements(int mem, double cpu, Map<String, Long> externalResources) {
        Quantity cpuQuantity = new Quantity(String.valueOf(cpu));
        Quantity memQuantity = new Quantity(mem + "Mi");
        ResourceRequirementsBuilder resourceRequirementsBuilder = (ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToRequests("memory", memQuantity)).addToRequests("cpu", cpuQuantity)).addToLimits("memory", memQuantity)).addToLimits("cpu", cpuQuantity);
        for (Map.Entry<String, Long> externalResource : externalResources.entrySet()) {
            Quantity resourceQuantity = new Quantity(String.valueOf(externalResource.getValue()));
            ((ResourceRequirementsBuilder)resourceRequirementsBuilder.addToRequests(externalResource.getKey(), resourceQuantity)).addToLimits(externalResource.getKey(), resourceQuantity);
            LOG.info("Request external resource {} with config key {}.", (Object)resourceQuantity.getAmount(), (Object)externalResource.getKey());
        }
        return resourceRequirementsBuilder.build();
    }

    public static String getCommonStartCommand(Configuration flinkConfig, ClusterComponent mode, String jvmMemOpts, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, String mainClass, @Nullable String mainArgs) {
        String logFileName;
        String opts;
        HashMap<String, String> startCommandValues = new HashMap<String, String>();
        startCommandValues.put("java", "$JAVA_HOME/bin/java");
        startCommandValues.put("classpath", "-classpath $FLINK_CLASSPATH");
        startCommandValues.put("jvmmem", jvmMemOpts);
        if (mode == ClusterComponent.JOB_MANAGER) {
            opts = KubernetesUtils.getJavaOpts(flinkConfig, (ConfigOption<String>)CoreOptions.FLINK_JM_JVM_OPTIONS);
            logFileName = "jobmanager";
        } else {
            opts = KubernetesUtils.getJavaOpts(flinkConfig, (ConfigOption<String>)CoreOptions.FLINK_TM_JVM_OPTIONS);
            logFileName = "taskmanager";
        }
        startCommandValues.put("jvmopts", opts);
        startCommandValues.put("logging", KubernetesUtils.getLogging(logDirectory + "/" + logFileName + ".log", configDirectory, hasLogback, hasLog4j));
        startCommandValues.put("class", mainClass);
        startCommandValues.put("args", mainArgs != null ? mainArgs : "");
        startCommandValues.put("redirects", "1> " + logDirectory + "/" + logFileName + ".out 2> " + logDirectory + "/" + logFileName + ".err");
        String commandTemplate = flinkConfig.getString(KubernetesConfigOptions.CONTAINER_START_COMMAND_TEMPLATE);
        return BootstrapTools.getStartCommand((String)commandTemplate, startCommandValues);
    }

    public static List<File> checkJarFileForApplicationMode(Configuration configuration) {
        return ((List)configuration.get(PipelineOptions.JARS)).stream().map(FunctionUtils.uncheckedFunction(uri -> {
            URI jarURI = PackagedProgramUtils.resolveURI((String)uri);
            if (jarURI.getScheme().equals("local") && jarURI.isAbsolute()) {
                return new File(jarURI.getPath());
            }
            throw new IllegalArgumentException("Only \"local\" is supported as schema for application mode. This assumes that the jar is located in the image, not the Flink client. An example of such path is: local:///opt/flink/examples/streaming/WindowJoin.jar");
        })).collect(Collectors.toList());
    }

    private static String getJavaOpts(Configuration flinkConfig, ConfigOption<String> configOption) {
        String baseJavaOpts = flinkConfig.getString(CoreOptions.FLINK_JVM_OPTIONS);
        if (flinkConfig.getString(configOption).length() > 0) {
            return baseJavaOpts + " " + flinkConfig.getString(configOption);
        }
        return baseJavaOpts;
    }

    private static String getLogging(String logFile, String confDir, boolean hasLogback, boolean hasLog4j) {
        StringBuilder logging = new StringBuilder();
        if (hasLogback || hasLog4j) {
            logging.append("-Dlog.file=").append(logFile);
            if (hasLogback) {
                logging.append(" -Dlogback.configurationFile=file:").append(confDir).append("/logback.xml");
            }
            if (hasLog4j) {
                logging.append(" -Dlog4j.configurationFile=file:").append(confDir).append("/log4j.properties");
            }
        }
        return logging.toString();
    }

    private KubernetesUtils() {
    }

    public static enum ClusterComponent {
        JOB_MANAGER,
        TASK_MANAGER;

    }
}

