/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.StatusFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageImportStatus;
import io.fabric8.openshift.api.model.ImageImportStatusFluent;

public class ImageImportStatusFluentImpl<A extends ImageImportStatusFluent<A>>
extends BaseFluent<A>
implements ImageImportStatusFluent<A> {
    private ImageBuilder image;
    private StatusBuilder status;
    private String tag;

    public ImageImportStatusFluentImpl() {
    }

    public ImageImportStatusFluentImpl(ImageImportStatus instance) {
        this.withImage(instance.getImage());
        this.withStatus(instance.getStatus());
        this.withTag(instance.getTag());
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    @Deprecated
    public Status getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public Status buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(Status status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new StatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ImageImportStatusFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ImageImportStatusFluent.StatusNested<A> withNewStatusLike(Status item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ImageImportStatusFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ImageImportStatusFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new StatusBuilder().build());
    }

    @Override
    public ImageImportStatusFluent.StatusNested<A> editOrNewStatusLike(Status item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public A withNewTag(String arg1) {
        return this.withTag(new String(arg1));
    }

    @Override
    public A withNewTag(StringBuilder arg1) {
        return this.withTag(new String(arg1));
    }

    @Override
    public A withNewTag(StringBuffer arg1) {
        return this.withTag(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageImportStatusFluentImpl that = (ImageImportStatusFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
    }

    public class StatusNestedImpl<N>
    extends StatusFluentImpl<ImageImportStatusFluent.StatusNested<N>>
    implements ImageImportStatusFluent.StatusNested<N>,
    Nested<N> {
        private final StatusBuilder builder;

        StatusNestedImpl(Status item) {
            this.builder = new StatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new StatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageImportStatusFluent.ImageNested<N>>
    implements ImageImportStatusFluent.ImageNested<N>,
    Nested<N> {
        private final ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

