/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.AbstractKubernetesWatcher;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.utils.KubernetesUtils;

public class KubernetesConfigMapWatcher
extends AbstractKubernetesWatcher<ConfigMap, KubernetesConfigMap> {
    public KubernetesConfigMapWatcher(FlinkKubeClient.WatchCallbackHandler<KubernetesConfigMap> callbackHandler) {
        super(callbackHandler);
    }

    @Override
    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
        this.logger.debug("Received {} event for configMap {}, details: {}{}", new Object[]{action, configMap.getMetadata().getName(), System.lineSeparator(), KubernetesUtils.tryToGetPrettyPrintYaml(configMap)});
        List<KubernetesConfigMap> configMaps = Collections.singletonList(new KubernetesConfigMap(configMap));
        switch (action) {
            case ADDED: {
                this.callbackHandler.onAdded(configMaps);
                break;
            }
            case MODIFIED: {
                this.callbackHandler.onModified(configMaps);
                break;
            }
            case ERROR: {
                this.callbackHandler.onError(configMaps);
                break;
            }
            case DELETED: {
                this.callbackHandler.onDeleted(configMaps);
                break;
            }
            default: {
                this.logger.debug("Ignore handling {} event for configMap {}", (Object)action, (Object)configMap.getMetadata().getName());
            }
        }
    }
}

