/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;

public class JarIdPathParameter
extends MessagePathParameter<String> {
    public static final String KEY = "jarid";

    protected JarIdPathParameter() {
        super(KEY);
    }

    protected String convertFromString(String value) throws ConversionException {
        Path path = Paths.get(value, new String[0]);
        if (path.getParent() != null) {
            throw new ConversionException(String.format("%s must be a filename only (%s)", KEY, path));
        }
        return value;
    }

    protected String convertToString(String value) {
        return value;
    }

    public String getDescription() {
        return "String value that identifies a jar. When uploading the jar a path is returned, where the filename is the ID. This value is equivalent to the `id` field in the list of uploaded jars (/jars).";
    }
}

