/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.util.function.TriFunctionWithException;

public class TestingBlobStore
implements BlobStore {
    @Nonnull
    private final TriFunctionWithException<File, JobID, BlobKey, Boolean, IOException> putFunction;
    @Nonnull
    private final BiFunction<JobID, BlobKey, Boolean> deleteFunction;
    @Nonnull
    private final Function<JobID, Boolean> deleteAllFunction;
    @Nonnull
    private final TriFunctionWithException<JobID, BlobKey, File, Boolean, IOException> getFunction;

    public TestingBlobStore(@Nonnull TriFunctionWithException<File, JobID, BlobKey, Boolean, IOException> putFunction, @Nonnull BiFunction<JobID, BlobKey, Boolean> deleteFunction, @Nonnull Function<JobID, Boolean> deleteAllFunction, @Nonnull TriFunctionWithException<JobID, BlobKey, File, Boolean, IOException> getFunction) {
        this.putFunction = putFunction;
        this.deleteFunction = deleteFunction;
        this.deleteAllFunction = deleteAllFunction;
        this.getFunction = getFunction;
    }

    public boolean put(File localFile, JobID jobId, BlobKey blobKey) throws IOException {
        return (Boolean)this.putFunction.apply((Object)localFile, (Object)jobId, (Object)blobKey);
    }

    public boolean delete(JobID jobId, BlobKey blobKey) {
        return this.deleteFunction.apply(jobId, blobKey);
    }

    public boolean deleteAll(JobID jobId) {
        return this.deleteAllFunction.apply(jobId);
    }

    public boolean get(JobID jobId, BlobKey blobKey, File localFile) throws IOException {
        return (Boolean)this.getFunction.apply((Object)jobId, (Object)blobKey, (Object)localFile);
    }
}

