/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.DefaultSubtaskAttemptNumberStore;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.executiongraph.SubtaskAttemptNumberStore;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.CoordinatorStoreImpl;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveBatchScheduler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionJobVertexTest {
    @Test
    public void testParallelismGreaterThanMaxParallelism() {
        JobVertex jobVertex = new JobVertex("testVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        jobVertex.setParallelism(172);
        jobVertex.setMaxParallelism(4);
        CommonTestUtils.assertThrows((String)"higher than the max parallelism", JobException.class, () -> ExecutionGraphTestUtils.getExecutionJobVertex(jobVertex));
    }

    @Test
    public void testLazyInitialization() throws Exception {
        int parallelism = 3;
        int configuredMaxParallelism = 12;
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex(3, 12, -1);
        MatcherAssert.assertThat((Object)ejv.getParallelism(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)ejv.getMaxParallelism(), (Matcher)CoreMatchers.is((Object)12));
        MatcherAssert.assertThat((Object)ejv.isInitialized(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ejv.getTaskVertices().length, (Matcher)CoreMatchers.is((Object)0));
        try {
            ejv.getInputs();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.getProducedDataSets();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.getSplitAssigner();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.getOperatorCoordinators();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.connectToPredecessors(Collections.emptyMap());
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.executionVertexFinished();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ejv.executionVertexUnFinished();
            Assert.fail((String)"failure is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExecutionJobVertexTest.initializeVertex(ejv);
        MatcherAssert.assertThat((Object)ejv.isInitialized(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ejv.getTaskVertices().length, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)ejv.getInputs().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)ejv.getProducedDataSets().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)ejv.getOperatorCoordinators().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=IllegalStateException.class)
    public void testErrorIfInitializationWithoutParallelismDecided() throws Exception {
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex();
        ExecutionJobVertexTest.initializeVertex(ejv);
    }

    @Test
    public void testSetParallelismLazily() throws Exception {
        int parallelism = 3;
        int defaultMaxParallelism = 13;
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex(-1, -1, 13);
        MatcherAssert.assertThat((Object)ejv.isParallelismDecided(), (Matcher)CoreMatchers.is((Object)false));
        ejv.setParallelism(3);
        MatcherAssert.assertThat((Object)ejv.isParallelismDecided(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ejv.getParallelism(), (Matcher)CoreMatchers.is((Object)3));
        ExecutionJobVertexTest.initializeVertex(ejv);
        MatcherAssert.assertThat((Object)ejv.getTaskVertices().length, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testConfiguredMaxParallelismIsRespected() throws Exception {
        int configuredMaxParallelism = 12;
        int defaultMaxParallelism = 13;
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex(-1, 12, 13);
        MatcherAssert.assertThat((Object)ejv.getMaxParallelism(), (Matcher)CoreMatchers.is((Object)12));
    }

    @Test
    public void testComputingMaxParallelismFromConfiguredParallelism() throws Exception {
        int parallelism = 300;
        int defaultMaxParallelism = 13;
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex(300, -1, 13);
        MatcherAssert.assertThat((Object)ejv.getMaxParallelism(), (Matcher)CoreMatchers.is((Object)512));
    }

    @Test
    public void testFallingBackToDefaultMaxParallelism() throws Exception {
        int defaultMaxParallelism = 13;
        ExecutionJobVertex ejv = ExecutionJobVertexTest.createDynamicExecutionJobVertex(-1, -1, 13);
        MatcherAssert.assertThat((Object)ejv.getMaxParallelism(), (Matcher)CoreMatchers.is((Object)13));
    }

    static void initializeVertex(ExecutionJobVertex vertex) throws Exception {
        vertex.initialize(1, Time.milliseconds((long)1L), 1L, (SubtaskAttemptNumberStore)new DefaultSubtaskAttemptNumberStore(Collections.emptyList()), (CoordinatorStore)new CoordinatorStoreImpl());
    }

    private static ExecutionJobVertex createDynamicExecutionJobVertex() throws Exception {
        return ExecutionJobVertexTest.createDynamicExecutionJobVertex(-1, -1, 1);
    }

    public static ExecutionJobVertex createDynamicExecutionJobVertex(int parallelism, int maxParallelism, int defaultMaxParallelism) throws Exception {
        JobVertex jobVertex = new JobVertex("testVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        jobVertex.createAndAddResultDataSet(new IntermediateDataSetID(), ResultPartitionType.BLOCKING);
        if (maxParallelism > 0) {
            jobVertex.setMaxParallelism(maxParallelism);
        }
        if (parallelism > 0) {
            jobVertex.setParallelism(parallelism);
        }
        DefaultExecutionGraph eg = TestingDefaultExecutionGraphBuilder.newBuilder().build();
        VertexParallelismStore vertexParallelismStore = AdaptiveBatchScheduler.computeVertexParallelismStoreForDynamicGraph(Collections.singletonList(jobVertex), (int)defaultMaxParallelism);
        VertexParallelismInformation vertexParallelismInfo = vertexParallelismStore.getParallelismInfo(jobVertex.getID());
        return new ExecutionJobVertex((InternalExecutionGraphAccessor)eg, jobVertex, vertexParallelismInfo);
    }
}

