/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;

class TestingHeartbeatTarget<T>
implements HeartbeatTarget<T> {
    private final BiFunction<ResourceID, T, CompletableFuture<Void>> receiveHeartbeatFunction;
    private final BiFunction<ResourceID, T, CompletableFuture<Void>> requestHeartbeatFunction;

    TestingHeartbeatTarget(BiFunction<ResourceID, T, CompletableFuture<Void>> receiveHeartbeatFunction, BiFunction<ResourceID, T, CompletableFuture<Void>> requestHeartbeatFunction) {
        this.receiveHeartbeatFunction = receiveHeartbeatFunction;
        this.requestHeartbeatFunction = requestHeartbeatFunction;
    }

    public CompletableFuture<Void> receiveHeartbeat(ResourceID heartbeatOrigin, T heartbeatPayload) {
        return this.receiveHeartbeatFunction.apply(heartbeatOrigin, (ResourceID)heartbeatPayload);
    }

    public CompletableFuture<Void> requestHeartbeat(ResourceID requestOrigin, T heartbeatPayload) {
        return this.requestHeartbeatFunction.apply(requestOrigin, (ResourceID)heartbeatPayload);
    }
}

