/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.NoOpFileChannelManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironmentBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderAndConsumerTest;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.PipelinedApproximateSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionTest;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.junit.Assert;
import org.junit.Test;

public class PipelinedApproximateSubpartitionTest
extends PipelinedSubpartitionTest {
    private static final int BUFFER_SIZE = 16;

    @Override
    PipelinedSubpartition createSubpartition() throws Exception {
        return PipelinedApproximateSubpartitionTest.createPipelinedApproximateSubpartition();
    }

    @Override
    @Test
    public void testIllegalReadViewRequest() {
    }

    @Test
    public void testRecreateReadView() throws Exception {
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.createPipelinedApproximateSubpartition();
        Assert.assertNotNull((Object)subpartition.createReadView(() -> {}));
        Assert.assertFalse((boolean)subpartition.isPartialBufferCleanupRequired());
        Assert.assertNotNull((Object)subpartition.createReadView(() -> {}));
        Assert.assertTrue((boolean)subpartition.isPartialBufferCleanupRequired());
    }

    @Test
    public void testSkipPartialDataEndsInBufferWithNoMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        Assert.assertNull((Object)subpartition.pollBuffer());
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(8, 9), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9);
    }

    @Test
    public void testSkipPartialDataEndsInBufferWithMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42), 0);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(8, 9), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9);
    }

    @Test
    public void testSkipPartialDataStartWithFullRecord() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42), 0);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(8, 9), 0);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 42, 8, 9);
    }

    @Test
    public void testSkipPartialDataStartWithinBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 42), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 42);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(8, 9), 0);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(10, 11), 0);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9, 10);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 11);
    }

    @Test
    public void testSkipPartialDataLongRecordOccupyEntireBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 8, 42), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        Assert.assertNull((Object)subpartition.pollBuffer());
    }

    @Test
    public void testSkipPartialDataLongRecordOccupyEntireBufferWithMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 8, 42), 0);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(100, 101, 102), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 100, 101);
        subpartition.setIsPartialBufferCleanupRequired();
        Assert.assertNull((Object)subpartition.pollBuffer());
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(200, 201, 202, 203), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 200, 201, 202);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 203);
    }

    @Test
    public void testSkipPartialDataLongRecordEndWithBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 42), 0);
        writer.emitRecord(BufferBuilderAndConsumerTest.toByteBuffer(100, 101, 102), 0);
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderAndConsumerTest.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 100, 101, 102);
    }

    private static PipelinedApproximateSubpartition createPipelinedApproximateSubpartition() throws IOException {
        BufferWritingResultPartition parent = PipelinedApproximateSubpartitionTest.createResultPartition();
        return (PipelinedApproximateSubpartition)parent.subpartitions[0];
    }

    private static PipelinedApproximateSubpartition getPipelinedApproximateSubpartition(BufferWritingResultPartition resultPartition) {
        return (PipelinedApproximateSubpartition)resultPartition.subpartitions[0];
    }

    private static BufferWritingResultPartition createResultPartition() throws IOException {
        NettyShuffleEnvironment network = new NettyShuffleEnvironmentBuilder().setNumNetworkBuffers(10).setBufferSize(16).build();
        ResultPartition resultPartition = PartitionTestUtils.createPartition(network, (FileChannelManager)NoOpFileChannelManager.INSTANCE, ResultPartitionType.PIPELINED_APPROXIMATE, 2);
        resultPartition.setup();
        return (BufferWritingResultPartition)resultPartition;
    }
}

