/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterException;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolServiceBuilder;
import org.apache.flink.runtime.jobmaster.utils.JobMasterBuilder;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.scheduler.TestingSchedulerNG;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;

public class JobMasterSchedulerTest
extends TestLogger {
    @ClassRule
    public static final TestingRpcServiceResource TESTING_RPC_SERVICE_RESOURCE = new TestingRpcServiceResource();

    @Test
    public void testIfStartSchedulingFailsJobMasterFails() throws Exception {
        FailingSchedulerFactory schedulerFactory = new FailingSchedulerFactory();
        JobMasterBuilder.TestingOnCompletionActions onCompletionActions = new JobMasterBuilder.TestingOnCompletionActions();
        JobMaster jobMaster = new JobMasterBuilder(JobGraphTestUtils.emptyJobGraph(), TESTING_RPC_SERVICE_RESOURCE.getTestingRpcService()).withSlotPoolServiceSchedulerFactory((SlotPoolServiceSchedulerFactory)DefaultSlotPoolServiceSchedulerFactory.create((SlotPoolServiceFactory)TestingSlotPoolServiceBuilder.newBuilder(), (SchedulerNGFactory)schedulerFactory)).withOnCompletionActions(onCompletionActions).createJobMaster();
        jobMaster.start();
        Assert.assertThat((Object)onCompletionActions.getJobMasterFailedFuture().join(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(JobMasterException.class)));
        try {
            jobMaster.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class FailingSchedulerFactory
    implements SchedulerNGFactory {
        private FailingSchedulerFactory() {
        }

        public SchedulerNG createInstance(Logger log, JobGraph jobGraph, Executor ioExecutor, Configuration jobMasterConfiguration, SlotPoolService slotPoolService, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Time slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, ExecutionDeploymentTracker executionDeploymentTracker, long initializationTimestamp, ComponentMainThreadExecutor mainThreadExecutor, FatalErrorHandler fatalErrorHandler, JobStatusListener jobStatusListener) {
            return TestingSchedulerNG.newBuilder().setStartSchedulingRunnable(() -> {
                throw new FlinkRuntimeException("Could not start scheduling.");
            }).build();
        }

        public JobManagerOptions.SchedulerType getSchedulerType() {
            return JobManagerOptions.SchedulerType.Ng;
        }
    }
}

