/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Optional;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriver;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class TestingMultipleComponentLeaderElectionDriver
implements MultipleComponentLeaderElectionDriver {
    private final BiConsumerWithException<String, LeaderInformation, Exception> publishLeaderInformationConsumer;
    private final ThrowingConsumer<String, Exception> deleteLeaderInformationConsumer;
    private boolean hasLeadership;
    private Optional<MultipleComponentLeaderElectionDriver.Listener> listener;

    private TestingMultipleComponentLeaderElectionDriver(BiConsumerWithException<String, LeaderInformation, Exception> publishLeaderInformationConsumer, ThrowingConsumer<String, Exception> deleteLeaderInformationConsumer) {
        this.publishLeaderInformationConsumer = publishLeaderInformationConsumer;
        this.deleteLeaderInformationConsumer = deleteLeaderInformationConsumer;
        this.hasLeadership = false;
        this.listener = Optional.empty();
    }

    public void grantLeadership() {
        if (!this.hasLeadership) {
            this.hasLeadership = true;
            this.listener.ifPresent(MultipleComponentLeaderElectionDriver.Listener::isLeader);
        }
    }

    public void revokeLeadership() {
        if (this.hasLeadership) {
            this.hasLeadership = false;
            this.listener.ifPresent(MultipleComponentLeaderElectionDriver.Listener::notLeader);
        }
    }

    public void setListener(MultipleComponentLeaderElectionDriver.Listener listener) {
        Preconditions.checkState((!this.listener.isPresent() ? 1 : 0) != 0, (Object)"Can only set a single listener.");
        this.listener = Optional.of(listener);
    }

    public void close() throws Exception {
    }

    public boolean hasLeadership() {
        return this.hasLeadership;
    }

    public void publishLeaderInformation(String componentId, LeaderInformation leaderInformation) throws Exception {
        this.publishLeaderInformationConsumer.accept((Object)componentId, (Object)leaderInformation);
    }

    public void deleteLeaderInformation(String componentId) throws Exception {
        this.deleteLeaderInformationConsumer.accept((Object)componentId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private BiConsumerWithException<String, LeaderInformation, Exception> publishLeaderInformationConsumer = (ignoredA, ignoredB) -> {};
        private ThrowingConsumer<String, Exception> deleteLeaderInformationConsumer = ignored -> {};

        public Builder setPublishLeaderInformationConsumer(BiConsumerWithException<String, LeaderInformation, Exception> publishLeaderInformationConsumer) {
            this.publishLeaderInformationConsumer = publishLeaderInformationConsumer;
            return this;
        }

        public Builder setDeleteLeaderInformationConsumer(ThrowingConsumer<String, Exception> deleteLeaderInformationConsumer) {
            this.deleteLeaderInformationConsumer = deleteLeaderInformationConsumer;
            return this;
        }

        public TestingMultipleComponentLeaderElectionDriver build() {
            return new TestingMultipleComponentLeaderElectionDriver(this.publishLeaderInformationConsumer, this.deleteLeaderInformationConsumer);
        }
    }
}

