/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.concurrent.Executor;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperHaServices;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ZooKeeperLeaderRetrievalTest
extends TestLogger {
    private static final RpcSystem RPC_SYSTEM = RpcSystem.load();
    private TestingServer testingServer;
    private Configuration config;
    private HighAvailabilityServices highAvailabilityServices;
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();

    @Before
    public void before() throws Exception {
        this.testingServer = new TestingServer();
        this.config = new Configuration();
        this.config.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
        this.config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.testingServer.getConnectString());
        this.highAvailabilityServices = new ZooKeeperHaServices(ZooKeeperUtils.startCuratorFramework((Configuration)this.config, (FatalErrorHandler)this.testingFatalErrorHandlerResource.getFatalErrorHandler()), (Executor)TestingUtils.defaultExecutor(), this.config, (BlobStoreService)new VoidBlobStore());
    }

    @After
    public void after() throws Exception {
        if (this.highAvailabilityServices != null) {
            this.highAvailabilityServices.closeAndCleanupAllData();
            this.highAvailabilityServices = null;
        }
        if (this.testingServer != null) {
            this.testingServer.stop();
            this.testingServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testConnectingAddressRetrievalWithDelayedLeaderElection() throws Exception {
        block14: {
            Duration timeout = Duration.ofMinutes(1L);
            long sleepingTime = 1000L;
            LeaderElectionService leaderElectionService = null;
            try {
                ServerSocket serverSocket;
                InetAddress localHost;
                String wrongAddress = RPC_SYSTEM.getRpcUrl("1.1.1.1", 1234, "foobar", AddressResolution.NO_ADDRESS_RESOLUTION, this.config);
                try {
                    localHost = InetAddress.getLocalHost();
                    serverSocket = new ServerSocket(0, 50, localHost);
                }
                catch (UnknownHostException e) {
                    System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
                    if (leaderElectionService != null) {
                        leaderElectionService.stop();
                    }
                    return;
                }
                catch (IOException e) {
                    block13: {
                        System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
                        if (leaderElectionService == null) break block13;
                        leaderElectionService.stop();
                    }
                    return;
                }
                InetSocketAddress correctInetSocketAddress = new InetSocketAddress(localHost, serverSocket.getLocalPort());
                String correctAddress = RPC_SYSTEM.getRpcUrl(localHost.getHostName(), correctInetSocketAddress.getPort(), "jobmanager", AddressResolution.NO_ADDRESS_RESOLUTION, this.config);
                LeaderElectionService faultyLeaderElectionService = this.highAvailabilityServices.getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID);
                TestingContender wrongLeaderAddressContender = new TestingContender(wrongAddress, faultyLeaderElectionService);
                faultyLeaderElectionService.start((LeaderContender)wrongLeaderAddressContender);
                FindConnectingAddress findConnectingAddress = new FindConnectingAddress(timeout, this.highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID));
                Thread thread = new Thread(findConnectingAddress);
                thread.start();
                leaderElectionService = this.highAvailabilityServices.getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID);
                TestingContender correctLeaderAddressContender = new TestingContender(correctAddress, leaderElectionService);
                Thread.sleep(sleepingTime);
                faultyLeaderElectionService.stop();
                leaderElectionService.start((LeaderContender)correctLeaderAddressContender);
                thread.join();
                InetAddress result = findConnectingAddress.getInetAddress();
                try (Socket socket = new Socket();){
                    InetSocketAddress bindP = new InetSocketAddress(result, 0);
                    socket.bind(bindP);
                    socket.connect(correctInetSocketAddress, 1000);
                    break block14;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (leaderElectionService != null) {
                    leaderElectionService.stop();
                }
            }
        }
    }

    @Test
    public void testTimeoutOfFindConnectingAddress() throws Exception {
        Duration timeout = Duration.ofSeconds(1L);
        LeaderRetrievalService leaderRetrievalService = this.highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID);
        InetAddress result = LeaderRetrievalUtils.findConnectingAddress((LeaderRetrievalService)leaderRetrievalService, (Duration)timeout, (RpcSystemUtils)RPC_SYSTEM);
        Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)result);
    }

    static class FindConnectingAddress
    implements Runnable {
        private final Duration timeout;
        private final LeaderRetrievalService leaderRetrievalService;
        private InetAddress result;
        private Exception exception;

        public FindConnectingAddress(Duration timeout, LeaderRetrievalService leaderRetrievalService) {
            this.timeout = timeout;
            this.leaderRetrievalService = leaderRetrievalService;
        }

        @Override
        public void run() {
            try {
                this.result = LeaderRetrievalUtils.findConnectingAddress((LeaderRetrievalService)this.leaderRetrievalService, (Duration)this.timeout, (RpcSystemUtils)RPC_SYSTEM);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public InetAddress getInetAddress() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

