/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.AbstractOuterJoinTaskTest;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.LeftOuterJoinDriver;
import org.apache.flink.runtime.operators.testutils.DelayingIterator;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.runtime.operators.testutils.InfiniteIntTupleIterator;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.apache.flink.shaded.guava30.com.google.common.base.Throwables;
import org.junit.Assert;
import org.junit.Test;

public class LeftOuterJoinTaskTest
extends AbstractOuterJoinTaskTest {
    private static final long HASH_MEM = 0x600000L;
    private final double hash_frac = 6291456.0 / (double)this.getMemoryManager().getMemorySize();

    public LeftOuterJoinTaskTest(ExecutionConfig config) {
        super(config);
    }

    @Override
    protected int calculateExpectedCount(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) {
        return valCnt1 * valCnt2 * Math.min(keyCnt1, keyCnt2) + (keyCnt1 > keyCnt2 ? (keyCnt1 - keyCnt2) * valCnt1 : 0);
    }

    @Override
    protected DriverStrategy getSortDriverStrategy() {
        return DriverStrategy.LEFT_OUTER_MERGE;
    }

    @Override
    protected AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> getOuterJoinDriver() {
        return new LeftOuterJoinDriver();
    }

    @Test
    public void testHash1LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 10;
        int valCnt2 = 2;
        this.testHashLeftOuterJoinTask(20, 1, 10, 2);
    }

    @Test
    public void testHash2LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 20;
        boolean valCnt2 = true;
        this.testHashLeftOuterJoinTask(20, 1, 20, 1);
    }

    @Test
    public void testHash3LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testHashLeftOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash4LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 1;
        this.testHashLeftOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash5LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testHashLeftOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash6LeftOuterJoinTask() throws Exception {
        int keyCnt1 = 10;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 2;
        this.testHashLeftOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    private void testHashLeftOuterJoinTask(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) throws Exception {
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.LEFT_HYBRIDHASH_BUILD_SECOND);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, false), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, false), this.serializer);
        this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        Assert.assertTrue((String)("Result set size was " + this.outList.size() + ". Expected was " + expCnt), (this.outList.size() == expCnt ? 1 : 0) != 0);
        this.outList.clear();
    }

    @Test(expected=ExpectedTestException.class)
    public void testFailingHashLeftOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.LEFT_HYBRIDHASH_BUILD_SECOND);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, true), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, true), this.serializer);
        this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockFailingJoinStub.class);
    }

    @Test
    public void testCancelLeftOuterJoinTaskWhileBuilding() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.LEFT_HYBRIDHASH_BUILD_SECOND);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(100, 100, true), this.serializer);
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort1()"){

            @Override
            public void run() {
                try {
                    LeftOuterJoinTaskTest.this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.join(60000L);
        Assert.assertFalse((String)"Task thread did not finish within 60 seconds", (boolean)taskRunner.isAlive());
        Throwable taskError = (Throwable)error.get();
        if (taskError != null) {
            Assert.fail((String)("Error in task while canceling:\n" + Throwables.getStackTraceAsString((Throwable)taskError)));
        }
    }

    @Test
    public void testCancelLeftOuterJoinTaskWhileProbing() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.LEFT_HYBRIDHASH_BUILD_SECOND);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        this.addInput(new UniformIntTupleGenerator(1, 1, true), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort1()"){

            @Override
            public void run() {
                try {
                    LeftOuterJoinTaskTest.this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.join(60000L);
        Assert.assertFalse((String)"Task thread did not finish within 60 seconds", (boolean)taskRunner.isAlive());
        Throwable taskError = (Throwable)error.get();
        if (taskError != null) {
            Assert.fail((String)("Error in task while canceling:\n" + Throwables.getStackTraceAsString((Throwable)taskError)));
        }
    }
}

