/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.BiDirectionalResourceToRequirementMapping;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class BiDirectionalResourceToRequirementMappingTest
extends TestLogger {
    @Test
    public void testIncrement() {
        BiDirectionalResourceToRequirementMapping mapping = new BiDirectionalResourceToRequirementMapping();
        ResourceProfile requirement = ResourceProfile.UNKNOWN;
        ResourceProfile resource = ResourceProfile.ANY;
        mapping.incrementCount(requirement, resource, 1);
        Assert.assertThat((Object)mapping.getRequirementsFulfilledBy(resource), (Matcher)Matchers.equalTo((Object)ResourceCounter.withResource((ResourceProfile)requirement, (int)1)));
        Assert.assertThat((Object)mapping.getResourcesFulfilling(requirement), (Matcher)Matchers.equalTo((Object)ResourceCounter.withResource((ResourceProfile)resource, (int)1)));
        Assert.assertThat((Object)mapping.getAllRequirementProfiles(), (Matcher)Matchers.contains((Object[])new ResourceProfile[]{requirement}));
        Assert.assertThat((Object)mapping.getAllResourceProfiles(), (Matcher)Matchers.contains((Object[])new ResourceProfile[]{resource}));
    }

    @Test
    public void testDecrement() {
        BiDirectionalResourceToRequirementMapping mapping = new BiDirectionalResourceToRequirementMapping();
        ResourceProfile requirement = ResourceProfile.UNKNOWN;
        ResourceProfile resource = ResourceProfile.ANY;
        mapping.incrementCount(requirement, resource, 1);
        mapping.decrementCount(requirement, resource, 1);
        Assert.assertTrue((boolean)mapping.getRequirementsFulfilledBy(resource).isEmpty());
        Assert.assertTrue((boolean)mapping.getResourcesFulfilling(requirement).isEmpty());
        Assert.assertThat((Object)mapping.getAllRequirementProfiles(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)mapping.getAllResourceProfiles(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)mapping.isEmpty(), (Matcher)Is.is((Object)true));
    }
}

