/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphToInputsLocationsRetrieverAdapter;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphToInputsLocationsRetrieverAdapterTest
extends TestLogger {
    @Test
    public void testGetConsumedResultPartitionsProducers() throws Exception {
        JobVertex producer1 = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex producer2 = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex consumer = ExecutionGraphTestUtils.createNoOpVertex(1);
        consumer.connectNewDataSetAsInput(producer1, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        consumer.connectNewDataSetAsInput(producer2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        DefaultExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(producer1, producer2, consumer);
        ExecutionGraphToInputsLocationsRetrieverAdapter inputsLocationsRetriever = new ExecutionGraphToInputsLocationsRetrieverAdapter((ExecutionGraph)eg);
        ExecutionVertexID evIdOfProducer1 = new ExecutionVertexID(producer1.getID(), 0);
        ExecutionVertexID evIdOfProducer2 = new ExecutionVertexID(producer2.getID(), 0);
        ExecutionVertexID evIdOfConsumer = new ExecutionVertexID(consumer.getID(), 0);
        Collection producersOfProducer1 = inputsLocationsRetriever.getConsumedResultPartitionsProducers(evIdOfProducer1);
        Collection producersOfProducer2 = inputsLocationsRetriever.getConsumedResultPartitionsProducers(evIdOfProducer2);
        Collection producersOfConsumer = inputsLocationsRetriever.getConsumedResultPartitionsProducers(evIdOfConsumer);
        Assert.assertThat((Object)producersOfProducer1, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)producersOfProducer2, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)producersOfConsumer, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)producersOfConsumer, (Matcher)Matchers.hasItem(Collections.singletonList(evIdOfProducer1)));
        Assert.assertThat((Object)producersOfConsumer, (Matcher)Matchers.hasItem(Collections.singletonList(evIdOfProducer2)));
    }

    @Test
    public void testGetEmptyTaskManagerLocationIfVertexNotScheduled() throws Exception {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex(1);
        DefaultExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(jobVertex);
        ExecutionGraphToInputsLocationsRetrieverAdapter inputsLocationsRetriever = new ExecutionGraphToInputsLocationsRetrieverAdapter((ExecutionGraph)eg);
        ExecutionVertexID executionVertexId = new ExecutionVertexID(jobVertex.getID(), 0);
        Optional taskManagerLocation = inputsLocationsRetriever.getTaskManagerLocation(executionVertexId);
        Assert.assertFalse((boolean)taskManagerLocation.isPresent());
    }

    @Test
    public void testGetTaskManagerLocationWhenScheduled() throws Exception {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex(1);
        TestingLogicalSlot testingLogicalSlot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
        DefaultExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(jobVertex);
        ExecutionGraphToInputsLocationsRetrieverAdapter inputsLocationsRetriever = new ExecutionGraphToInputsLocationsRetrieverAdapter((ExecutionGraph)eg);
        ExecutionVertex onlyExecutionVertex = (ExecutionVertex)eg.getAllExecutionVertices().iterator().next();
        onlyExecutionVertex.getCurrentExecutionAttempt().transitionState(ExecutionState.SCHEDULED);
        onlyExecutionVertex.deployToSlot((LogicalSlot)testingLogicalSlot);
        ExecutionVertexID executionVertexId = new ExecutionVertexID(jobVertex.getID(), 0);
        Optional taskManagerLocationOptional = inputsLocationsRetriever.getTaskManagerLocation(executionVertexId);
        Assert.assertTrue((boolean)taskManagerLocationOptional.isPresent());
        CompletableFuture taskManagerLocationFuture = (CompletableFuture)taskManagerLocationOptional.get();
        Assert.assertThat(taskManagerLocationFuture.get(), (Matcher)Matchers.is((Object)testingLogicalSlot.getTaskManagerLocation()));
    }

    @Test
    public void testGetNonExistingExecutionVertexWillThrowException() throws Exception {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex(1);
        DefaultExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(jobVertex);
        ExecutionGraphToInputsLocationsRetrieverAdapter inputsLocationsRetriever = new ExecutionGraphToInputsLocationsRetrieverAdapter((ExecutionGraph)eg);
        ExecutionVertexID invalidExecutionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        try {
            inputsLocationsRetriever.getTaskManagerLocation(invalidExecutionVertexId);
            Assert.fail((String)"Should throw exception if execution vertex doesn't exist!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

