/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionTopology;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSchedulingPipelinedRegionTest
extends TestLogger {
    @Test
    public void gettingUnknownVertexThrowsException() {
        Map resultPartitionById = Collections.emptyMap();
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(Collections.emptySet(), resultPartitionById::get);
        ExecutionVertexID unknownVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        try {
            pipelinedRegion.getVertex(unknownVertexId);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)(unknownVertexId + " not found")));
        }
    }

    @Test
    public void returnsVertices() {
        DefaultExecutionVertex vertex = new DefaultExecutionVertex(new ExecutionVertexID(new JobVertexID(), 0), Collections.emptyList(), () -> ExecutionState.CREATED, Collections.emptyList(), partitionID -> {
            throw new UnsupportedOperationException();
        });
        Set<DefaultExecutionVertex> vertices = Collections.singleton(vertex);
        Map resultPartitionById = Collections.emptyMap();
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(vertices, resultPartitionById::get);
        Iterator vertexIterator = pipelinedRegion.getVertices().iterator();
        MatcherAssert.assertThat((Object)vertexIterator.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(vertexIterator.next(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)vertex)));
        MatcherAssert.assertThat((Object)vertexIterator.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsIncidentBlockingPartitions() throws Exception {
        JobVertex a = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex b = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex c = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex d = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex e = ExecutionGraphTestUtils.createNoOpVertex(1);
        b.connectNewDataSetAsInput(a, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        c.connectNewDataSetAsInput(b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        d.connectNewDataSetAsInput(b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        e.connectNewDataSetAsInput(c, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        e.connectNewDataSetAsInput(d, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        DefaultExecutionGraph simpleTestGraph = ExecutionGraphTestUtils.createSimpleTestGraph(a, b, c, d, e);
        DefaultExecutionTopology topology = DefaultExecutionTopology.fromExecutionGraph((DefaultExecutionGraph)simpleTestGraph);
        DefaultSchedulingPipelinedRegion firstPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(a.getID(), 0));
        DefaultSchedulingPipelinedRegion secondPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(e.getID(), 0));
        DefaultExecutionVertex vertexB0 = topology.getVertex(new ExecutionVertexID(b.getID(), 0));
        IntermediateResultPartitionID b0ConsumedResultPartition = ((DefaultResultPartition)Iterables.getOnlyElement((Iterable)vertexB0.getConsumedResults())).getId();
        HashSet<IntermediateResultPartitionID> secondPipelinedRegionConsumedResults = new HashSet<IntermediateResultPartitionID>();
        for (ConsumedPartitionGroup consumedPartitionGroup : secondPipelinedRegion.getAllBlockingConsumedPartitionGroups()) {
            for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
                if (secondPipelinedRegion.contains(topology.getResultPartition(partitionId).getProducer().getId())) continue;
                secondPipelinedRegionConsumedResults.add(partitionId);
            }
        }
        MatcherAssert.assertThat((Object)firstPipelinedRegion.getAllBlockingConsumedPartitionGroups().iterator().hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(secondPipelinedRegionConsumedResults, (Matcher)Matchers.contains((Object[])new IntermediateResultPartitionID[]{b0ConsumedResultPartition}));
    }
}

