/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.time.Duration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.scheduler.metrics.DeploymentStateTimeMetrics;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetricTest;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DeploymentStateTimeMetricsTest {
    private static final MetricOptions.JobStatusMetricsSettings settings = StateTimeMetricTest.enable(MetricOptions.JobStatusMetrics.STATE, MetricOptions.JobStatusMetrics.CURRENT_TIME, MetricOptions.JobStatusMetrics.TOTAL_TIME);

    DeploymentStateTimeMetricsTest() {
    }

    @Test
    void testInitialValues() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics deploymentStateTimeMetrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        Assertions.assertThat((long)deploymentStateTimeMetrics.getCurrentTime()).isEqualTo(0L);
        Assertions.assertThat((long)deploymentStateTimeMetrics.getTotalTime()).isEqualTo(0L);
        Assertions.assertThat((long)deploymentStateTimeMetrics.getBinary()).isEqualTo(0L);
    }

    @Test
    void testDeploymentStartsOnFirstDeploying() {
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(0L);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(1L);
    }

    @Test
    void testDeploymentStart_batch_notTriggeredIfOneDeploymentIsRunning() {
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(0L);
    }

    @Test
    void testDeploymentEnd_batch() {
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(0L);
    }

    @Test
    void testDeploymentEnd_streaming() {
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.STREAMING, settings);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(1L);
        metrics.onStateUpdate(id2, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(0L);
    }

    @Test
    void testDeploymentEnd_streaming_ignoresTerminalDeployments() {
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.STREAMING, settings);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        metrics.onStateUpdate(id1, ExecutionState.INITIALIZING, ExecutionState.FINISHED);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(1L);
        metrics.onStateUpdate(id2, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        Assertions.assertThat((long)metrics.getBinary()).isEqualTo(0L);
    }

    @Test
    void testGetCurrentTime() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        Assertions.assertThat((long)metrics.getCurrentTime()).isEqualTo(5L);
    }

    @Test
    void testGetCurrentTimeResetOndDeployentEnd() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        Assertions.assertThat((long)metrics.getCurrentTime()).isEqualTo(0L);
    }

    @Test
    void testGetCurrentTime_notResetOnSecondaryDeployment() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        Assertions.assertThat((long)metrics.getCurrentTime()).isEqualTo(10L);
    }

    @Test
    void testGetTotalTime() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.FINISHED);
        Assertions.assertThat((long)metrics.getTotalTime()).isEqualTo(5L);
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id2, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id2, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        metrics.onStateUpdate(id2, ExecutionState.DEPLOYING, ExecutionState.FINISHED);
        Assertions.assertThat((long)metrics.getTotalTime()).isEqualTo(10L);
    }

    @Test
    void testGetTotalTimeIncludesCurrentTime() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        clock.advanceTime(Duration.ofMillis(5L));
        Assertions.assertThat((long)metrics.getTotalTime()).isEqualTo(5L);
    }

    @Test
    void testCleanStateAfterFullDeploymentCycle() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.INITIALIZING);
        metrics.onStateUpdate(id1, ExecutionState.INITIALIZING, ExecutionState.RUNNING);
        metrics.onStateUpdate(id1, ExecutionState.RUNNING, ExecutionState.CANCELING);
        metrics.onStateUpdate(id1, ExecutionState.CANCELING, ExecutionState.CANCELED);
        Assertions.assertThat((boolean)metrics.hasCleanState()).isEqualTo(true);
    }

    @Test
    void testCleanStateAfterEarlyDeploymentFailure() {
        ManualClock clock = new ManualClock(Duration.ofMillis(5L).toNanos());
        DeploymentStateTimeMetrics metrics = new DeploymentStateTimeMetrics(JobType.BATCH, settings, (Clock)clock);
        ExecutionAttemptID id1 = new ExecutionAttemptID();
        ExecutionAttemptID id2 = new ExecutionAttemptID();
        metrics.onStateUpdate(id1, ExecutionState.CREATED, ExecutionState.SCHEDULED);
        metrics.onStateUpdate(id1, ExecutionState.SCHEDULED, ExecutionState.DEPLOYING);
        metrics.onStateUpdate(id1, ExecutionState.DEPLOYING, ExecutionState.FAILED);
        Assertions.assertThat((boolean)metrics.hasCleanState()).isEqualTo(true);
    }
}

