/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.taskexecutor.HostBindPolicy;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import sun.net.util.IPAddressUtil;

@NotThreadSafe
public class TaskManagerRunnerConfigurationTest
extends TestLogger {
    private static final RpcSystem RPC_SYSTEM = RpcSystem.load();
    private static final int TEST_TIMEOUT_SECONDS = 10;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskManagerRpcServiceShouldBindToConfiguredTaskManagerHostname() throws Exception {
        String taskmanagerHost = "testhostname";
        Configuration config = TaskManagerRunnerConfigurationTest.createFlinkConfigWithPredefinedTaskManagerHostname("testhostname");
        HighAvailabilityServices highAvailabilityServices = this.createHighAvailabilityServices(config);
        RpcService taskManagerRpcService = null;
        try {
            taskManagerRpcService = TaskManagerRunner.createRpcService((Configuration)config, (HighAvailabilityServices)highAvailabilityServices, (RpcSystem)RPC_SYSTEM);
            Assert.assertThat((Object)taskManagerRpcService.getPort(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
            Assert.assertThat((Object)taskManagerRpcService.getAddress(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"testhostname")));
        }
        catch (Throwable throwable) {
            TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
            highAvailabilityServices.closeAndCleanupAllData();
            throw throwable;
        }
        TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
        highAvailabilityServices.closeAndCleanupAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskManagerRpcServiceShouldBindToHostnameAddress() throws Exception {
        Configuration config = TaskManagerRunnerConfigurationTest.createFlinkConfigWithHostBindPolicy(HostBindPolicy.NAME);
        HighAvailabilityServices highAvailabilityServices = this.createHighAvailabilityServices(config);
        RpcService taskManagerRpcService = null;
        try {
            taskManagerRpcService = TaskManagerRunner.createRpcService((Configuration)config, (HighAvailabilityServices)highAvailabilityServices, (RpcSystem)RPC_SYSTEM);
            Assert.assertThat((Object)taskManagerRpcService.getAddress(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        }
        catch (Throwable throwable) {
            TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
            highAvailabilityServices.closeAndCleanupAllData();
            throw throwable;
        }
        TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
        highAvailabilityServices.closeAndCleanupAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskManagerRpcServiceShouldBindToIpAddressDeterminedByConnectingToResourceManager() throws Exception {
        ServerSocket testJobManagerSocket = TaskManagerRunnerConfigurationTest.openServerSocket();
        Configuration config = TaskManagerRunnerConfigurationTest.createFlinkConfigWithJobManagerPort(testJobManagerSocket.getLocalPort());
        HighAvailabilityServices highAvailabilityServices = this.createHighAvailabilityServices(config);
        RpcService taskManagerRpcService = null;
        try {
            taskManagerRpcService = TaskManagerRunner.createRpcService((Configuration)config, (HighAvailabilityServices)highAvailabilityServices, (RpcSystem)RPC_SYSTEM);
            Assert.assertThat((Object)taskManagerRpcService.getAddress(), (Matcher)Matchers.is(TaskManagerRunnerConfigurationTest.ipAddress()));
        }
        catch (Throwable throwable) {
            TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
            highAvailabilityServices.closeAndCleanupAllData();
            IOUtils.closeQuietly((AutoCloseable)testJobManagerSocket);
            throw throwable;
        }
        TaskManagerRunnerConfigurationTest.maybeCloseRpcService(taskManagerRpcService);
        highAvailabilityServices.closeAndCleanupAllData();
        IOUtils.closeQuietly((AutoCloseable)testJobManagerSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreatingTaskManagerRpcServiceShouldFailIfRpcPortRangeIsInvalid() throws Exception {
        Configuration config = new Configuration(TaskManagerRunnerConfigurationTest.createFlinkConfigWithPredefinedTaskManagerHostname("example.org"));
        config.setString(TaskManagerOptions.RPC_PORT, "-1");
        HighAvailabilityServices highAvailabilityServices = this.createHighAvailabilityServices(config);
        try {
            TaskManagerRunner.createRpcService((Configuration)config, (HighAvailabilityServices)highAvailabilityServices, (RpcSystem)RPC_SYSTEM);
            Assert.fail((String)"Should fail because -1 is not a valid port range");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Invalid port range definition: -1"));
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultFsParameterLoading() throws Exception {
        try {
            File tmpDir = this.temporaryFolder.newFolder();
            File confFile = new File(tmpDir, "flink-conf.yaml");
            URI defaultFS = new URI("otherFS", null, "localhost", 1234, null, null, null);
            PrintWriter pw1 = new PrintWriter(confFile);
            pw1.println("fs.default-scheme: " + defaultFS);
            pw1.close();
            String[] args = new String[]{"--configDir", tmpDir.toString()};
            Configuration configuration = TaskManagerRunner.loadConfiguration((String[])args);
            FileSystem.initialize((Configuration)configuration);
            Assert.assertEquals((Object)defaultFS, (Object)FileSystem.getDefaultFsUri());
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    @Test
    public void testLoadDynamicalProperties() throws IOException, FlinkParseException {
        File tmpDir = this.temporaryFolder.newFolder();
        File confFile = new File(tmpDir, "flink-conf.yaml");
        PrintWriter pw1 = new PrintWriter(confFile);
        long managedMemory = 0x10000000L;
        pw1.println(JobManagerOptions.ADDRESS.key() + ": localhost");
        pw1.println(TaskManagerOptions.MANAGED_MEMORY_SIZE.key() + ": " + 0x10000000L + "b");
        pw1.close();
        String jmHost = "host1";
        int jmPort = 12345;
        String[] args = new String[]{"--configDir", tmpDir.toString(), "-D" + JobManagerOptions.ADDRESS.key() + "=" + "host1", "-D" + JobManagerOptions.PORT.key() + "=" + 12345};
        Configuration configuration = TaskManagerRunner.loadConfiguration((String[])args);
        Assert.assertEquals((Object)MemorySize.parse((String)"268435456b"), (Object)configuration.get(TaskManagerOptions.MANAGED_MEMORY_SIZE));
        Assert.assertEquals((Object)"host1", (Object)configuration.get(JobManagerOptions.ADDRESS));
        Assert.assertEquals((long)12345L, (long)configuration.getInteger(JobManagerOptions.PORT));
    }

    private static Configuration createFlinkConfigWithPredefinedTaskManagerHostname(String taskmanagerHost) {
        Configuration config = new Configuration();
        config.setString(TaskManagerOptions.HOST, taskmanagerHost);
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        return new UnmodifiableConfiguration(config);
    }

    private static Configuration createFlinkConfigWithHostBindPolicy(HostBindPolicy bindPolicy) {
        Configuration config = new Configuration();
        config.setString(TaskManagerOptions.HOST_BIND_POLICY, bindPolicy.toString());
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        config.set(AkkaOptions.LOOKUP_TIMEOUT_DURATION, (Object)Duration.ofMillis(10L));
        return new UnmodifiableConfiguration(config);
    }

    private static Configuration createFlinkConfigWithJobManagerPort(int port) {
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        config.setInteger(JobManagerOptions.PORT, port);
        return new UnmodifiableConfiguration(config);
    }

    private HighAvailabilityServices createHighAvailabilityServices(Configuration config) throws Exception {
        return HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (AddressResolution)AddressResolution.NO_ADDRESS_RESOLUTION, (RpcSystemUtils)RpcSystem.load(), (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
    }

    private static ServerSocket openServerSocket() {
        try {
            return new ServerSocket(0);
        }
        catch (IOException e) {
            Assume.assumeNoException((String)"Skip test because could not open a server socket", (Throwable)e);
            throw new RuntimeException("satisfy compiler");
        }
    }

    private static void maybeCloseRpcService(@Nullable RpcService rpcService) throws Exception {
        if (rpcService != null) {
            rpcService.stopService().get(10L, TimeUnit.SECONDS);
        }
    }

    private static TypeSafeMatcher<String> ipAddress() {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String value) {
                return IPAddressUtil.isIPv4LiteralAddress(value) || IPAddressUtil.isIPv6LiteralAddress(value);
            }

            public void describeTo(Description description) {
                description.appendText("Is an ip address.");
            }
        };
    }
}

