/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskexecutor.slot.DefaultTimerService;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.Executors;

public enum TaskSlotUtils {

    private static final long DEFAULT_SLOT_TIMEOUT = 10000L;
    public static final ResourceProfile DEFAULT_RESOURCE_PROFILE = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemory(new MemorySize(102400L)).setTaskOffHeapMemory(MemorySize.ZERO).setManagedMemory(new MemorySize(40960L)).setNetworkMemory(new MemorySize(102400L)).build();

    public static <T extends TaskSlotPayload> TaskSlotTableImpl<T> createTaskSlotTable(int numberOfSlots) {
        return TaskSlotUtils.createTaskSlotTable(numberOfSlots, TaskSlotUtils.createDefaultTimerService());
    }

    public static <T extends TaskSlotPayload> TaskSlotTable<T> createTaskSlotTable(int numberOfSlots, Time timeout) {
        return TaskSlotUtils.createTaskSlotTable(numberOfSlots, TaskSlotUtils.createDefaultTimerService(timeout.toMilliseconds()));
    }

    public static <T extends TaskSlotPayload> TaskSlotTableImpl<T> createTaskSlotTable(int numberOfSlots, TimerService<AllocationID> timerService) {
        return new TaskSlotTableImpl(numberOfSlots, TaskSlotUtils.createTotalResourceProfile(numberOfSlots), DEFAULT_RESOURCE_PROFILE, 4096, timerService, (Executor)Executors.newDirectExecutorService());
    }

    public static ResourceProfile createTotalResourceProfile(int numberOfSlots) {
        ResourceProfile result = DEFAULT_RESOURCE_PROFILE;
        for (int i = 0; i < numberOfSlots - 1; ++i) {
            result = result.merge(DEFAULT_RESOURCE_PROFILE);
        }
        return result;
    }

    public static TimerService<AllocationID> createDefaultTimerService() {
        return TaskSlotUtils.createDefaultTimerService(10000L);
    }

    public static TimerService<AllocationID> createDefaultTimerService(long shutdownTimeout) {
        return new DefaultTimerService(TestingUtils.defaultExecutor(), shutdownTimeout);
    }
}

