/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.testutils.PseudoRandomValueSelector;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PseudoRandomValueSelectorTest
extends TestLogger {
    @Test
    public void testRandomizationOfValues() {
        Double[] alternatives = (Double[])IntStream.range(0, 1000).boxed().map(Double::valueOf).toArray(Double[]::new);
        PseudoRandomValueSelector valueSelector = PseudoRandomValueSelector.create("seed");
        HashSet<Double> uniqueValues = new HashSet<Double>(1);
        for (int i = 0; i < 100; ++i) {
            Double selectedValue = this.selectValue(valueSelector, TaskManagerOptions.CPU_CORES, alternatives);
            uniqueValues.add(selectedValue);
        }
        MatcherAssert.assertThat((Object)uniqueValues.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    private <T> T selectValue(PseudoRandomValueSelector valueSelector, ConfigOption<T> option, T ... alternatives) {
        Configuration configuration = new Configuration();
        Assert.assertNull((Object)configuration.get(option));
        valueSelector.select(configuration, option, alternatives);
        Object selected = configuration.get(option);
        Assert.assertNotNull((Object)selected);
        return (T)selected;
    }

    @Test
    public void testRandomizationWithSeed() {
        Double[] alternatives = (Double[])IntStream.range(0, 1000).boxed().map(Double::valueOf).toArray(Double[]::new);
        HashSet<Double> uniqueValues = new HashSet<Double>(1);
        for (int i = 0; i < 100; ++i) {
            PseudoRandomValueSelector selector = PseudoRandomValueSelector.create("test" + i);
            uniqueValues.add(this.selectValue(selector, TaskManagerOptions.CPU_CORES, alternatives));
        }
        MatcherAssert.assertThat((Object)uniqueValues.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testStableRandomization() {
        Double[] doubles = (Double[])IntStream.range(0, 1000).boxed().map(Double::valueOf).toArray(Double[]::new);
        Integer[] numbers = (Integer[])IntStream.range(0, 1000).boxed().toArray(Integer[]::new);
        String[] strings = (String[])IntStream.range(0, 1000).mapToObj(i -> "string" + i).toArray(String[]::new);
        HashSet<Tuple3> uniqueValues = new HashSet<Tuple3>(1);
        for (int i2 = 0; i2 < 100; ++i2) {
            PseudoRandomValueSelector selector = PseudoRandomValueSelector.create("test");
            uniqueValues.add(new Tuple3((Object)this.selectValue(selector, TaskManagerOptions.CPU_CORES, doubles), (Object)this.selectValue(selector, JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB, numbers), (Object)this.selectValue(selector, CheckpointingOptions.SAVEPOINT_DIRECTORY, strings)));
        }
        Assert.assertEquals((long)1L, (long)uniqueValues.size());
    }

    @Test
    public void readCommitId() {
        Assume.assumeNotNull((Object[])new Object[]{ZooKeeperTestUtils.runsOnCIInfrastructure()});
        String envCommitId = EnvironmentInformation.getGitCommitId();
        Assume.assumeFalse((boolean)envCommitId.equals("DecafC0ffeeD0d0F00d"));
        try {
            new ProcessBuilder("git", "version").start();
        }
        catch (IOException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Optional<String> gitCommitId = PseudoRandomValueSelector.getGitCommitId();
        Assert.assertTrue((boolean)gitCommitId.isPresent());
        Assert.assertEquals((Object)envCommitId, (Object)gitCommitId.get());
    }
}

